/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.database;

import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseConfigParams;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseGenerateCredentialsResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseGenerateStaticRoleCredentialsResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseListConnectionsResultData;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseListRolesResultData;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseListStaticRolesResultData;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseReadConnectionResultData;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseReadRoleResultData;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseReadStaticRoleResultData;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseRequestFactory;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseUpdateRoleParams;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseUpdateStaticRoleParams;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class VaultSecretsDatabase
extends VaultMountableAPI<VaultSecretsDatabaseRequestFactory> {
    public static VaultSecretsDatabaseRequestFactory FACTORY = VaultSecretsDatabaseRequestFactory.INSTANCE;

    public VaultSecretsDatabase(VaultRequestExecutor executor, String mountPath, VaultSecretsDatabaseRequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultSecretsDatabase(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<Void> configureConnection(String connectionName, VaultSecretsDatabaseConfigParams params) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).configureConnection(this.mountPath, connectionName, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsDatabaseReadConnectionResultData> readConnection(String connectionName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).readConnection(this.mountPath, connectionName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listConnections() {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).listConnections(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsDatabaseListConnectionsResultData)r.getData()).getKeys());
    }

    public CompletionStage<Void> deleteConnection(String connectionName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).deleteConnection(this.mountPath, connectionName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> resetConnection(String connectionName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).resetConnection(this.mountPath, connectionName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> rotateRootCredentials(String connectionName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).rotateRootCredentials(this.mountPath, connectionName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> updateRole(String roleName, VaultSecretsDatabaseUpdateRoleParams params) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).updateRole(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsDatabaseReadRoleResultData> readRole(String roleName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).readRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listRoles() {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).listRoles(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsDatabaseListRolesResultData)r.getData()).getKeys());
    }

    public CompletionStage<Void> deleteRole(String roleName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).deleteRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsDatabaseGenerateCredentialsResult> generateCredentials(String roleName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).generateCredentials(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> updateStaticRole(String roleName, VaultSecretsDatabaseUpdateStaticRoleParams params) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).updateStaticRole(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsDatabaseReadStaticRoleResultData> readStaticRole(String roleName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).readStaticRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listStaticRoles() {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).listStaticRoles(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsDatabaseListStaticRolesResultData)r.getData()).getKeys());
    }

    public CompletionStage<Void> deleteStaticRole(String roleName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).deleteStaticRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsDatabaseGenerateStaticRoleCredentialsResult> generateStaticRoleCredentials(String roleName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).generateStaticRoleCredentials(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> rotateStaticCredentials(String roleName) {
        return this.executor.execute(((VaultSecretsDatabaseRequestFactory)this.factory).rotateStaticCredentials(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }
}

