/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.transit;

import io.quarkus.vault.client.api.common.VaultCompletionStages;
import io.quarkus.vault.client.api.common.VaultFormat;
import io.quarkus.vault.client.api.common.VaultHashAlgorithm;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.api.common.VaultRandomSource;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitBackupKeyResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitCreateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDataKeyType;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptBatchResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptResultBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptBatchResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptResultBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitExportKeyResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitExportKeyType;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitGenerateDataKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitGenerateDataKeyResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitGetWrappingKeyResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHashResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHmacBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHmacBatchResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHmacResultBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHmacResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitImportKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitImportKeyVersionParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitKeyInfo;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitListKeysResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRandomData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitReadCacheConfigResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitReadKeysConfigResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRequestFactory;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapBatchResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapResultBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRotateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSecureExportKeyResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignBatchResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignCsrParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignCsrResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignResultBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitUpdateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitUpdateKeysConfigParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyBatchResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyResultBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyResultData;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public class VaultSecretsTransit
extends VaultMountableAPI<VaultSecretsTransitRequestFactory> {
    public static VaultSecretsTransitRequestFactory FACTORY = VaultSecretsTransitRequestFactory.INSTANCE;

    public VaultSecretsTransit(VaultRequestExecutor executor, String mountPath, VaultSecretsTransitRequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultSecretsTransit(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<Optional<VaultSecretsTransitKeyInfo>> createKey(String name, VaultSecretsTransitCreateKeyParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).createKey(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> Optional.ofNullable(r).map(VaultLeasedResult::getData));
    }

    public CompletionStage<Void> importKey(String name, VaultSecretsTransitImportKeyParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).importKey(this.mountPath, name, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> importKeyVersion(String name, VaultSecretsTransitImportKeyVersionParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).importKeyVersion(this.mountPath, name, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<String> getWrappingKey() {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).getWrappingKey(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitGetWrappingKeyResultData)r.getData()).getPublicKey());
    }

    public CompletionStage<List<String>> listKeys() {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).listKeys(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitListKeysResultData)r.getData()).getKeys()).exceptionallyCompose(VaultCompletionStages.recoverNotFound(() -> List.of()));
    }

    public CompletionStage<VaultSecretsTransitKeyInfo> readKey(String name) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).readKey(this.mountPath, name)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> deleteKey(String name) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).deleteKey(this.mountPath, name)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> updateKey(String name, VaultSecretsTransitUpdateKeyParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).updateKey(this.mountPath, name, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> rotateKey(String name, VaultSecretsTransitRotateKeyParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).rotateKey(this.mountPath, name, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsTransitSignCsrResultData> signCsr(String name, VaultSecretsTransitSignCsrParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).signCsr(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> setCertificateChain(String name, String version, String certificateChain) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).setCertificateChain(this.mountPath, name, version, certificateChain)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsTransitSecureExportKeyResultData> secureExportKey(String destination, String source, String version) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).secureExportKey(this.mountPath, destination, source, version)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsTransitExportKeyResultData> exportKey(VaultSecretsTransitExportKeyType keyType, String name, String version) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).exportKey(this.mountPath, keyType, name, version)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsTransitReadKeysConfigResultData> readKeysConfig() {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).readKeysConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> updateKeysConfig(VaultSecretsTransitUpdateKeysConfigParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).updateKeysConfig(this.mountPath, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsTransitEncryptResultData> encrypt(String name, VaultSecretsTransitEncryptParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).encrypt(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<VaultSecretsTransitEncryptResultBatchItem>> encryptBatch(String name, VaultSecretsTransitEncryptBatchParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).encryptBatch(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitEncryptBatchResultData)r.getData()).getBatchResults());
    }

    public CompletionStage<byte[]> decrypt(String name, VaultSecretsTransitDecryptParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).decrypt(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitDecryptResultData)r.getData()).getPlaintext());
    }

    public CompletionStage<List<VaultSecretsTransitDecryptResultBatchItem>> decryptBatch(String name, VaultSecretsTransitDecryptBatchParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).decryptBatch(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitDecryptBatchResultData)r.getData()).getBatchResults());
    }

    public CompletionStage<VaultSecretsTransitRewrapResultData> rewrap(String name, VaultSecretsTransitRewrapParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).rewrap(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<VaultSecretsTransitRewrapResultBatchItem>> rewrapBatch(String name, VaultSecretsTransitRewrapBatchParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).rewrapBatch(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitRewrapBatchResultData)r.getData()).getBatchResults());
    }

    public CompletionStage<VaultSecretsTransitGenerateDataKeyResultData> generateDataKey(VaultSecretsTransitDataKeyType type, String name, VaultSecretsTransitGenerateDataKeyParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).generateDataKey(this.mountPath, type, name, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<byte[]> random(Integer bytes, VaultRandomSource source, VaultFormat format) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).random(this.mountPath, bytes, source, format)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitRandomData)r.getData()).getBytes(format));
    }

    public CompletionStage<String> hash(VaultHashAlgorithm algorithm, byte[] input, VaultFormat format) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).hash(this.mountPath, algorithm, input, format)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitHashResultData)r.getData()).getSum());
    }

    public CompletionStage<String> hmac(String name, VaultHashAlgorithm algorithm, byte[] input, Integer keyVersion) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).hmac(this.mountPath, name, algorithm, input, keyVersion)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitHmacResultData)r.getData()).getHmac());
    }

    public CompletionStage<List<VaultSecretsTransitHmacResultBatchItem>> hmacBatch(String name, VaultSecretsTransitHmacBatchParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).hmacBatch(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitHmacBatchResultData)r.getData()).getBatchResults());
    }

    public CompletionStage<VaultSecretsTransitSignResultData> sign(String name, VaultSecretsTransitSignParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).sign(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<VaultSecretsTransitSignResultBatchItem>> signBatch(String name, VaultSecretsTransitSignBatchParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).signBatch(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitSignBatchResultData)r.getData()).getBatchResults());
    }

    public CompletionStage<Boolean> verify(String name, VaultSecretsTransitVerifyParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).verify(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitVerifyResultData)r.getData()).isValid());
    }

    public CompletionStage<List<VaultSecretsTransitVerifyResultBatchItem>> verifyBatch(String name, VaultSecretsTransitVerifyBatchParams params) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).verifyBatch(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitVerifyBatchResultData)r.getData()).getBatchResults());
    }

    public CompletionStage<String> backupKey(String name) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).backupKey(this.mountPath, name)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitBackupKeyResultData)r.getData()).getBackup());
    }

    public CompletionStage<Void> restoreKey(String name, String backup, Boolean force) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).restoreKey(this.mountPath, name, backup, force)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> trimKey(String name, Integer minAvailableVersion) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).trimKey(this.mountPath, name, minAvailableVersion)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> updateCacheConfig(Integer size) {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).updateCacheConfig(this.mountPath, size)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Integer> readCacheConfig() {
        return this.executor.execute(((VaultSecretsTransitRequestFactory)this.factory).readCacheConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTransitReadCacheConfigResultData)r.getData()).getSize());
    }
}

