/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.transit;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.vault.client.api.common.VaultFormat;
import io.quarkus.vault.client.common.VaultModel;
import java.util.Base64;
import java.util.HexFormat;

public class VaultSecretsTransitRandomData
implements VaultModel {
    @JsonProperty(value="random_bytes")
    private String randomBytes;

    public String getRandomBytes() {
        return this.randomBytes;
    }

    public VaultSecretsTransitRandomData setRandomBytes(String randomBytes) {
        this.randomBytes = randomBytes;
        return this;
    }

    public byte[] getBytes(VaultFormat format) {
        if (format == null || format == VaultFormat.BASE64) {
            return Base64.getDecoder().decode(this.randomBytes);
        }
        if (format == VaultFormat.HEX) {
            return HexFormat.of().parseHex(this.randomBytes);
        }
        throw new IllegalArgumentException("Unsupported format: " + String.valueOf(format));
    }
}

