/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.auth;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthEnableConfig;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthEnableParams;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthListResult;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthReadResult;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthReadTuneResult;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthTuneOptions;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultSysAuthRequestFactory
extends VaultRequestFactory {
    public static final VaultSysAuthRequestFactory INSTANCE = new VaultSysAuthRequestFactory();

    public VaultSysAuthRequestFactory() {
        super("[SYS (auth)]");
    }

    public VaultRequest<VaultSysAuthListResult> list() {
        return VaultRequest.get(this.getTraceOpName("List")).path("sys", "auth").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysAuthListResult.class));
    }

    public VaultRequest<VaultSysAuthReadResult> read(String path) {
        return VaultRequest.get(this.getTraceOpName("Read")).path("sys", "auth", path).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysAuthReadResult.class));
    }

    public VaultRequest<Void> enable(String path, String type, String description, VaultSysAuthEnableConfig config) {
        return VaultRequest.post(this.getTraceOpName("Enable")).path("sys", "auth", path).body(new VaultSysAuthEnableParams().setType(type).setDescription(description).setConfig(config)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> disable(String path) {
        return VaultRequest.delete(this.getTraceOpName("Disable")).path("sys", "auth", path).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSysAuthReadTuneResult> readTune(String path) {
        return VaultRequest.get(this.getTraceOpName("Read Tune")).path("sys", "auth", path, "tune").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysAuthReadTuneResult.class));
    }

    public VaultRequest<Void> tune(String path, VaultSysAuthTuneOptions options) {
        return VaultRequest.post(this.getTraceOpName("Tune")).path("sys", "auth", path, "tune").body(options).expectNoContentStatus().build();
    }
}

