/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.leases;

import io.quarkus.vault.client.api.common.VaultAPI;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesCountResult;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesListResultData;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesReadResultData;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesRenewResult;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesRequestFactory;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class VaultSysLeases
extends VaultAPI<VaultSysLeasesRequestFactory> {
    public static VaultSysLeasesRequestFactory FACTORY = VaultSysLeasesRequestFactory.INSTANCE;

    public VaultSysLeases(VaultRequestExecutor executor, VaultSysLeasesRequestFactory factory) {
        super(executor, factory);
    }

    public VaultSysLeases(VaultRequestExecutor executor) {
        this(executor, FACTORY);
    }

    public CompletionStage<VaultSysLeasesReadResultData> read(String leaseId) {
        return this.executor.execute(((VaultSysLeasesRequestFactory)this.factory).read(leaseId)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> list(String prefix) {
        return this.executor.execute(((VaultSysLeasesRequestFactory)this.factory).list(prefix)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSysLeasesListResultData)r.getData()).getKeys());
    }

    public CompletionStage<VaultSysLeasesRenewResult> renew(String leaseId, Duration increment) {
        return this.executor.execute(((VaultSysLeasesRequestFactory)this.factory).renew(leaseId, increment)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> revoke(String leaseId, boolean sync) {
        return this.executor.execute(((VaultSysLeasesRequestFactory)this.factory).revoke(leaseId, sync)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> revokeForce(String prefix) {
        return this.executor.execute(((VaultSysLeasesRequestFactory)this.factory).revokeForce(prefix)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> revokePrefix(String prefix) {
        return this.executor.execute(((VaultSysLeasesRequestFactory)this.factory).revokePrefix(prefix)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> tidy() {
        return this.executor.execute(((VaultSysLeasesRequestFactory)this.factory).tidy()).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSysLeasesCountResult> count(String type, Boolean includeChildNamespaces) {
        return this.executor.execute(((VaultSysLeasesRequestFactory)this.factory).count(type, includeChildNamespaces)).thenApply(VaultResponse::getResult);
    }
}

