/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.plugins;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsListAuthResult;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsListDatabaseResult;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsListResult;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsListSecretResult;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsReadResult;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsRegisterParams;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsReloadMountsParams;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsReloadPluginParams;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import java.util.List;

public class VaultSysPluginsRequestFactory
extends VaultRequestFactory {
    public static final VaultSysPluginsRequestFactory INSTANCE = new VaultSysPluginsRequestFactory();

    public VaultSysPluginsRequestFactory() {
        super("[SYS (plugins)]");
    }

    public VaultRequest<VaultSysPluginsListResult> list() {
        return VaultRequest.get(this.getTraceOpName("List")).path("sys/plugins", "catalog").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysPluginsListResult.class));
    }

    public VaultRequest<VaultSysPluginsListAuthResult> listAuth() {
        return VaultRequest.list(this.getTraceOpName("List Auth")).path("sys/plugins", "catalog", "auth").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysPluginsListAuthResult.class));
    }

    public VaultRequest<VaultSysPluginsListDatabaseResult> listDatabase() {
        return VaultRequest.list(this.getTraceOpName("List Database")).path("sys/plugins", "catalog", "database").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysPluginsListDatabaseResult.class));
    }

    public VaultRequest<VaultSysPluginsListSecretResult> listSecret() {
        return VaultRequest.list(this.getTraceOpName("List Secret")).path("sys/plugins", "catalog", "secret").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysPluginsListSecretResult.class));
    }

    public VaultRequest<VaultSysPluginsReadResult> read(String type, String name, String version) {
        return VaultRequest.get(this.getTraceOpName("Read")).path("sys/plugins", "catalog", type, name).queryParam(version != null, "version", version).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysPluginsReadResult.class));
    }

    public VaultRequest<VaultSysPluginsReadResult> read(String type, String name) {
        return VaultRequest.get(this.getTraceOpName("Read")).path("sys/plugins", "catalog", type, name).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysPluginsReadResult.class));
    }

    public VaultRequest<Void> register(String type, String name, VaultSysPluginsRegisterParams params) {
        return VaultRequest.post(this.getTraceOpName("Register")).path("sys/plugins", "catalog", type, name).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<Void> remove(String type, String name, String version) {
        return VaultRequest.delete(this.getTraceOpName("Remove")).path("sys/plugins", "catalog", type, name).queryParam(version != null, "version", version).expectNoContentStatus().build();
    }

    public VaultRequest<Void> remove(String type, String name) {
        return VaultRequest.delete(this.getTraceOpName("Remove")).path("sys/plugins", "catalog", type, name).expectNoContentStatus().build();
    }

    public VaultRequest<Void> reloadPlugin(String plugin, String scope) {
        return VaultRequest.post(this.getTraceOpName("Reload Plugin")).path("sys/plugins", "reload", "backend").body(new VaultSysPluginsReloadPluginParams().setPlugin(plugin).setScope(scope)).expectOkOrAcceptedStatus().build();
    }

    public VaultRequest<Void> reloadMounts(List<String> mounts, String scope) {
        return VaultRequest.post(this.getTraceOpName("Reload Mounts")).path("sys/plugins", "reload", "backend").body(new VaultSysPluginsReloadMountsParams().setMounts(mounts).setScope(scope)).expectOkOrAcceptedStatus().build();
    }
}

