/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.wrapping;

import com.fasterxml.jackson.core.type.TypeReference;
import io.quarkus.vault.client.api.common.VaultAPI;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultWrapInfo;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingLookupResultData;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingRequestFactory;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingUnwrapResult;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.json.JsonMapping;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class VaultSysWrapping
extends VaultAPI<VaultSysWrappingRequestFactory> {
    public static VaultSysWrappingRequestFactory FACTORY = VaultSysWrappingRequestFactory.INSTANCE;

    public VaultSysWrapping(VaultRequestExecutor executor, VaultSysWrappingRequestFactory factory) {
        super(executor, factory);
    }

    public VaultSysWrapping(VaultRequestExecutor executor) {
        this(executor, FACTORY);
    }

    public CompletionStage<VaultSysWrappingLookupResultData> lookup(String token) {
        return this.executor.execute(((VaultSysWrappingRequestFactory)this.factory).lookup(token)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultWrapInfo> rewrap(String token) {
        return this.executor.execute(((VaultSysWrappingRequestFactory)this.factory).rewrap(token)).thenApply(VaultResponse::getResult).thenApply(r -> r.getWrapInfo());
    }

    public CompletionStage<VaultSysWrappingUnwrapResult> unwrap() {
        return this.executor.execute(((VaultSysWrappingRequestFactory)this.factory).unwrap()).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSysWrappingUnwrapResult> unwrap(String token) {
        return this.executor.execute(((VaultSysWrappingRequestFactory)this.factory).unwrap(token)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultWrapInfo> wrap(Map<String, Object> data, Duration wrapTtl) {
        return this.executor.execute(((VaultSysWrappingRequestFactory)this.factory).wrap(data, wrapTtl)).thenApply(VaultResponse::getResult).thenApply(r -> r.getWrapInfo());
    }

    public <T> CompletionStage<T> unwrapAs(String token, Class<T> type) {
        return this.unwrap(token).thenApply(r -> {
            Object val = r.getAuth() != null ? r.getAuth() : r.getData();
            return JsonMapping.convert(val, type);
        });
    }

    public CompletionStage<VaultWrapInfo> wrap(Object data, Duration wrapTtl) {
        return this.wrap(JsonMapping.convert(data, new TypeReference<Map<String, Object>>(){}), wrapTtl);
    }
}

