/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.wrapping;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingLookupParams;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingLookupResult;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingRewrapParams;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingRewrapResult;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingUnwrapResult;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingWrapParams;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingWrapResult;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import java.time.Duration;
import java.util.Map;

public class VaultSysWrappingRequestFactory
extends VaultRequestFactory {
    public static final VaultSysWrappingRequestFactory INSTANCE = new VaultSysWrappingRequestFactory();

    public VaultSysWrappingRequestFactory() {
        super("[SYS (wrapping)]");
    }

    public VaultRequest<VaultSysWrappingLookupResult> lookup(String token) {
        return VaultRequest.post(this.getTraceOpName("Lookup")).path("sys", "wrapping", "lookup").body(new VaultSysWrappingLookupParams().setToken(token)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysWrappingLookupResult.class));
    }

    public VaultRequest<VaultSysWrappingRewrapResult> rewrap(String token) {
        return VaultRequest.post(this.getTraceOpName("Rewrap")).path("sys", "wrapping", "rewrap").body(new VaultSysWrappingRewrapParams().setToken(token)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysWrappingRewrapResult.class));
    }

    public VaultRequest<VaultSysWrappingUnwrapResult> unwrap() {
        return VaultRequest.post(this.getTraceOpName("Unwrap")).path("sys", "wrapping", "unwrap").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysWrappingUnwrapResult.class));
    }

    public VaultRequest<VaultSysWrappingUnwrapResult> unwrap(String token) {
        return VaultRequest.post(this.getTraceOpName("Unwrap")).path("sys", "wrapping", "unwrap").token(token).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysWrappingUnwrapResult.class));
    }

    public VaultRequest<VaultSysWrappingWrapResult> wrap(Map<String, Object> data, Duration wrapTtl) {
        return VaultRequest.post(this.getTraceOpName("Wrap")).path("sys", "wrapping", "wrap").wrapTTL(wrapTtl).body(new VaultSysWrappingWrapParams().setData(data)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysWrappingWrapResult.class));
    }
}

