/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import io.quarkus.vault.client.auth.VaultAuthOptions;
import io.quarkus.vault.client.auth.VaultCachingTokenProvider;
import io.quarkus.vault.client.auth.VaultKubernetesTokenProvider;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class VaultKubernetesAuthOptions
extends VaultAuthOptions {
    public static final Path DEFAULT_KUBERNETES_JWT_TOKEN_PATH = Path.of("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]);
    public final String mountPath;
    public final String role;
    public final Supplier<CompletionStage<String>> jwtProvider;

    private VaultKubernetesAuthOptions(Builder builder) {
        super(builder.cachingRenewGracePeriod);
        this.mountPath = Objects.requireNonNull(builder.mountPath);
        this.role = Objects.requireNonNull(builder.role);
        this.jwtProvider = Objects.requireNonNull(builder.jwtProvider);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String mountPath = "kubernetes";
        private String role;
        private Supplier<CompletionStage<String>> jwtProvider = VaultKubernetesTokenProvider.jwtTokenPathReader(DEFAULT_KUBERNETES_JWT_TOKEN_PATH);
        private Duration cachingRenewGracePeriod = VaultCachingTokenProvider.DEFAULT_RENEW_GRACE_PERIOD;

        public Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder jwtTokenPath(Path jwtTokenPath) {
            this.jwtProvider = VaultKubernetesTokenProvider.jwtTokenPathReader(jwtTokenPath);
            return this;
        }

        public Builder jwtProvider(Supplier<CompletionStage<String>> jwtProvider) {
            this.jwtProvider = jwtProvider;
            return this;
        }

        public Builder caching(Duration cachingRenewGracePeriod) {
            this.cachingRenewGracePeriod = cachingRenewGracePeriod;
            return this;
        }

        public Builder noCaching() {
            this.cachingRenewGracePeriod = Duration.ZERO;
            return this;
        }

        public VaultKubernetesAuthOptions build() {
            return new VaultKubernetesAuthOptions(this);
        }
    }
}

