/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;
import java.util.logging.Logger;

public abstract class VaultTimeLimited {
    private static final Logger log = Logger.getLogger(VaultTimeLimited.class.getName());
    private final InstantSource instantSource;
    private final Instant created;
    private final boolean renewable;
    private final Duration leaseDuration;

    public VaultTimeLimited(boolean renewable, Duration leaseDuration, InstantSource instantSource) {
        this(renewable, leaseDuration, instantSource.instant(), instantSource);
    }

    public VaultTimeLimited(boolean renewable, Duration leaseDuration, Instant created, InstantSource instantSource) {
        this.instantSource = instantSource;
        this.created = created;
        this.renewable = renewable;
        this.leaseDuration = leaseDuration;
    }

    public InstantSource getInstantSource() {
        return this.instantSource;
    }

    public Instant getCreated() {
        return this.created;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public boolean isExpired() {
        return this.instantSource.instant().isAfter(this.getExpiresAt());
    }

    public boolean isExpiringWithin(Duration gracePeriod) {
        return this.instantSource.instant().plus(gracePeriod).isAfter(this.getExpiresAt());
    }

    public boolean shouldExtend(Duration gracePeriod) {
        return !this.isExpired() && this.renewable && this.isExpiringWithin(gracePeriod);
    }

    public Instant getExpiresAt() {
        return this.created.plus(this.leaseDuration);
    }

    public String info() {
        return "renewable: " + this.renewable + ", leaseDuration: " + String.valueOf(this.leaseDuration) + ", valid_until: " + String.valueOf(this.getExpiresAt());
    }

    public void leaseDurationSanityCheck(String nickname, Duration gracePeriod) {
        if (this.leaseDuration.compareTo(gracePeriod) < 0) {
            log.warning(nickname + " lease duration " + String.valueOf(this.leaseDuration) + "s is smaller than the renew grace period " + gracePeriod.getSeconds() + "s");
        }
    }
}

