/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitKeyVersion;
import io.quarkus.vault.client.json.VaultDurationStringDeserializer;
import io.quarkus.vault.client.json.VaultDurationStringSerializer;
import io.quarkus.vault.client.json.VaultSecretsTransitKeyVersionDeserializer;
import java.time.Duration;

public class VaultModule
extends SimpleModule {
    public static final VaultModule INSTANCE = new VaultModule();

    public VaultModule() {
        super("VaultModule");
        this.addSerializer(Duration.class, (JsonSerializer)new VaultDurationStringSerializer());
        this.addDeserializer(Duration.class, (JsonDeserializer)new VaultDurationStringDeserializer());
        this.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (VaultSecretsTransitKeyVersion.class.isAssignableFrom(beanDesc.getBeanClass())) {
                    return new VaultSecretsTransitKeyVersionDeserializer(deserializer);
                }
                return deserializer;
            }
        });
    }
}

