/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitKeyVersion;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class VaultSecretsTransitKeyVersionDeserializer
extends DelegatingDeserializer {
    public VaultSecretsTransitKeyVersionDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(defaultDeserializer);
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new VaultSecretsTransitKeyVersionDeserializer(newDelegatee);
    }

    public VaultSecretsTransitKeyVersion deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.currentToken().isNumeric()) {
            OffsetDateTime creationTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond((Long)p.readValueAs(Long.class)), ZoneOffset.UTC);
            return new VaultSecretsTransitKeyVersion().setCreationTime(creationTime);
        }
        return (VaultSecretsTransitKeyVersion)super.deserialize(p, ctxt);
    }
}

