/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client;

import io.quarkus.vault.client.VaultException;
import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.ArrayList;
import java.util.List;

public class VaultClientException
extends VaultException {
    private final String operationName;
    private final String requestPath;
    private final Integer status;
    private final List<String> errors;
    private final String body;

    public VaultClientException(VaultRequest<?> request, Integer status, List<String> errors, Throwable cause) {
        this(request.getOperation(), request.getUrl().toString(), status, errors, null, cause);
    }

    public VaultClientException(VaultRequest<?> request, Integer status, String body, Throwable cause) {
        this(request.getOperation(), request.getUrl().toString(), status, null, body, cause);
    }

    public VaultClientException(VaultResponse<?> response, List<String> errors, Throwable cause) {
        this(response.getRequest().getOperation(), response.getRequest().getUrl().toString(), (Integer)response.getStatusCode(), errors, cause);
    }

    public VaultClientException(String operationName, String requestPath, Integer status, String body, Throwable cause) {
        this(operationName, requestPath, status, null, body, cause);
    }

    public VaultClientException(String operationName, String requestPath, Integer status, List<String> errors, Throwable cause) {
        this(operationName, requestPath, status, errors, null, cause);
    }

    private VaultClientException(String operationName, String requestPath, Integer status, List<String> errors, String body, Throwable cause) {
        super(VaultClientException.formatMessage(operationName, requestPath, status, errors), cause);
        this.operationName = operationName;
        this.requestPath = requestPath;
        this.status = status;
        this.errors = errors;
        this.body = body;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isPermissionDenied() {
        return this.status == 403;
    }

    public VaultClientException withError(String error) {
        ArrayList<String> errors = this.errors == null ? new ArrayList<String>() : new ArrayList<String>(this.errors);
        errors.add(0, error);
        return new VaultClientException(this.operationName, this.requestPath, this.status, errors, this.body, this.getCause());
    }

    static String formatMessage(String operationName, String requestPath, Integer status, List<String> errors) {
        StringBuilder sb = new StringBuilder();
        sb.append(operationName).append("' at path '").append(requestPath).append("'");
        if (status != null) {
            sb.append(" with status ").append(status);
        }
        if (errors != null && !errors.isEmpty()) {
            sb.append(System.lineSeparator()).append("errors:").append(System.lineSeparator()).append(String.join((CharSequence)System.lineSeparator(), errors));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return "VaultClientException{operationName='" + this.operationName + "', requestPath='" + this.requestPath + "', status=" + this.status + (String)(this.errors != null ? ", errors=" + String.valueOf(this.errors) : "") + (String)(this.body != null ? ", body='" + this.body + "'" : "") + "}";
    }

    public boolean hasErrorContaining(String message) {
        return this.errors != null && this.errors.stream().anyMatch(e -> e.contains(message));
    }
}

