/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api;

import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabase;
import io.quarkus.vault.client.api.secrets.kv1.VaultSecretsKV1;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKI;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQ;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTP;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransit;
import io.quarkus.vault.client.common.VaultRequestExecutor;

public class VaultSecretsAccessor {
    public static final String DEFAULT_TOTP_MOUNT_PATH = "totp";
    public static final String DEFAULT_DATABASE_MOUNT_PATH = "database";
    public static final String DEFAULT_KV2_MOUNT_PATH = "secret";
    public static final String DEFAULT_TRANSIT_MOUNT_PATH = "transit";
    public static final String DEFAULT_KV1_MOUNT_PATH = "secret";
    public static final String DEFAULT_PKI_MOUNT_PATH = "pki";
    public static final String DEFAULT_RABBITMQ_MOUNT_PATH = "rabbitmq";
    private final VaultRequestExecutor executor;

    public VaultSecretsAccessor(VaultRequestExecutor executor) {
        this.executor = executor;
    }

    public VaultRequestExecutor getExecutor() {
        return this.executor;
    }

    public VaultSecretsTOTP totp() {
        return new VaultSecretsTOTP(this.executor, DEFAULT_TOTP_MOUNT_PATH);
    }

    public VaultSecretsTOTP totp(String mountPath) {
        return new VaultSecretsTOTP(this.executor, mountPath);
    }

    public VaultSecretsDatabase database() {
        return new VaultSecretsDatabase(this.executor, DEFAULT_DATABASE_MOUNT_PATH);
    }

    public VaultSecretsDatabase database(String mountPath) {
        return new VaultSecretsDatabase(this.executor, mountPath);
    }

    public VaultSecretsKV2 kv2() {
        return new VaultSecretsKV2(this.executor, "secret");
    }

    public VaultSecretsKV2 kv2(String mountPath) {
        return new VaultSecretsKV2(this.executor, mountPath);
    }

    public VaultSecretsTransit transit() {
        return new VaultSecretsTransit(this.executor, DEFAULT_TRANSIT_MOUNT_PATH);
    }

    public VaultSecretsTransit transit(String mountPath) {
        return new VaultSecretsTransit(this.executor, mountPath);
    }

    public VaultSecretsKV1 kv1() {
        return new VaultSecretsKV1(this.executor, "secret");
    }

    public VaultSecretsKV1 kv1(String mountPath) {
        return new VaultSecretsKV1(this.executor, mountPath);
    }

    public VaultSecretsPKI pki() {
        return new VaultSecretsPKI(this.executor, DEFAULT_PKI_MOUNT_PATH);
    }

    public VaultSecretsPKI pki(String mountPath) {
        return new VaultSecretsPKI(this.executor, mountPath);
    }

    public VaultSecretsRabbitMQ rabbitMQ() {
        return new VaultSecretsRabbitMQ(this.executor, DEFAULT_RABBITMQ_MOUNT_PATH);
    }

    public VaultSecretsRabbitMQ rabbitMQ(String mountPath) {
        return new VaultSecretsRabbitMQ(this.executor, mountPath);
    }
}

