/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultTokenType implements VaultModel
{
    SERVICE("service"),
    BATCH("batch"),
    DEFAULT("default"),
    DEFAULT_SERVICE("default-service"),
    DEFAULT_BATCH("default-batch");

    private final String value;

    private VaultTokenType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultTokenType from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultTokenType v : VaultTokenType.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

