/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsDatabaseCredentialType implements VaultModel
{
    PASSWORD("password"),
    RSA_PRIVATE_KEY("rsa_private_key"),
    CLIENT_CERTIFICATE("client_certificate");

    private final String value;

    private VaultSecretsDatabaseCredentialType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsDatabaseCredentialType from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsDatabaseCredentialType v : VaultSecretsDatabaseCredentialType.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

