/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.kv2;

import io.quarkus.vault.client.api.common.VaultCompletionStages;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ListSecretsResultData;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadConfigResultData;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadSecretData;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadSecretMetadataResultData;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadSubkeysResultData;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2RequestFactory;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2SecretMetadataParams;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2UpdateSecretOptions;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class VaultSecretsKV2
extends VaultMountableAPI<VaultSecretsKV2RequestFactory> {
    public static VaultSecretsKV2RequestFactory FACTORY = VaultSecretsKV2RequestFactory.INSTANCE;

    public VaultSecretsKV2(VaultRequestExecutor executor, String mountPath, VaultSecretsKV2RequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultSecretsKV2(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<Void> updateConfig(Integer maxVersions, Boolean casRequired, String deleteVersionAfter) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).updateConfig(this.mountPath, maxVersions, casRequired, deleteVersionAfter)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsKV2ReadConfigResultData> readConfig() {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).readConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsKV2ReadSecretData> readSecret(String path, @Nullable Integer version) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).readSecret(this.mountPath, path, version)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsKV2ReadSecretData> readSecret(String path) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).readSecret(this.mountPath, path)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsKV2ReadSubkeysResultData> readSubkeys(String path, @Nullable Integer version, @Nullable Integer depth) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).readSubkeys(this.mountPath, path, version, depth)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsKV2ReadSubkeysResultData> readSubkeys(String path) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).readSubkeys(this.mountPath, path)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsKV2ReadSecretData> updateSecret(String path, VaultSecretsKV2UpdateSecretOptions options, Map<String, Object> data) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).updateSecret(this.mountPath, path, options, data)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsKV2ReadSecretData> patchSecret(String path, VaultSecretsKV2UpdateSecretOptions options, Map<String, Object> data) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).patchSecret(this.mountPath, path, options, data)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> deleteSecret(String path) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).deleteSecret(this.mountPath, path)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> deleteSecretVersions(String path, List<Integer> versions) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).deleteSecretVersions(this.mountPath, path, versions)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> undeleteSecretVersions(String path, List<Integer> versions) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).undeleteSecretVersions(this.mountPath, path, versions)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> destroySecretVersions(String path, List<Integer> versions) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).destroySecretVersions(this.mountPath, path, versions)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<List<String>> listSecrets(String path) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).listSecrets(this.mountPath, path)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsKV2ListSecretsResultData)r.getData()).getKeys()).exceptionallyCompose(VaultCompletionStages.recoverNotFound(() -> List.of()));
    }

    public CompletionStage<VaultSecretsKV2ReadSecretMetadataResultData> readSecretMetadata(String path) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).readSecretMetadata(this.mountPath, path)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> updateSecretMetadata(String path, @Nullable Integer maxVersions, @Nullable Boolean casRequired, @Nullable String deleteVersionAfter, @Nullable Map<String, Object> customMetadata) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).updateSecretMetadata(this.mountPath, path, maxVersions, casRequired, deleteVersionAfter, customMetadata)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> patchSecretMetadata(String path, VaultSecretsKV2SecretMetadataParams params) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).patchSecretMetadata(this.mountPath, path, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> deleteSecretMetadata(String path) {
        return this.executor.execute(((VaultSecretsKV2RequestFactory)this.factory).deleteSecretMetadata(this.mountPath, path)).thenApply(VaultResponse::getResult);
    }
}

