/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.pki;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsPKIKeyUsage implements VaultModel
{
    DIGITALSIGNATURE("DigitalSignature"),
    CONTENTCOMMITMENT("ContentCommitment"),
    KEYENCIPHERMENT("KeyEncipherment"),
    DATAENCIPHERMENT("DataEncipherment"),
    KEYAGREEMENT("KeyAgreement"),
    CERTSIGN("CertSign"),
    CRLSIGN("CRLSign"),
    ENCIPHERONLY("EncipherOnly"),
    DECIPHERONLY("DecipherOnly");

    private final String value;

    private VaultSecretsPKIKeyUsage(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsPKIKeyUsage from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsPKIKeyUsage v : VaultSecretsPKIKeyUsage.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

