/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.transit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsTransitSignatureAlgorithm implements VaultModel
{
    PSS("pss"),
    PKCS1V15("pkcs1v15");

    private final String value;

    private VaultSecretsTransitSignatureAlgorithm(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsTransitSignatureAlgorithm from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsTransitSignatureAlgorithm v : VaultSecretsTransitSignatureAlgorithm.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

