/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import io.quarkus.vault.client.auth.VaultAuthOptions;
import io.quarkus.vault.client.auth.VaultAuthRequest;
import io.quarkus.vault.client.auth.VaultCachingTokenProvider;
import io.quarkus.vault.client.auth.unwrap.VaultClientTokenUnwrappingProvider;
import io.quarkus.vault.client.auth.unwrap.VaultValueProvider;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class VaultStaticClientTokenAuthOptions
extends VaultAuthOptions {
    public final Function<VaultAuthRequest, CompletionStage<String>> tokenProvider;

    private VaultStaticClientTokenAuthOptions(Builder builder) {
        super(builder.cachingRenewGracePeriod);
        this.tokenProvider = builder.tokenProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Function<VaultAuthRequest, CompletionStage<String>> tokenProvider;
        private Duration cachingRenewGracePeriod = VaultCachingTokenProvider.DEFAULT_RENEW_GRACE_PERIOD;

        public Builder token(String token) {
            this.tokenProvider = VaultValueProvider.staticValue(token);
            return this;
        }

        public Builder unwrappingToken(String wrappedToken) {
            this.tokenProvider = new VaultClientTokenUnwrappingProvider(wrappedToken);
            return this;
        }

        public Builder customTokenProvider(Function<VaultAuthRequest, CompletionStage<String>> tokenProvider) {
            this.tokenProvider = tokenProvider;
            return this;
        }

        public Builder caching(Duration cachingRenewGracePeriod) {
            this.cachingRenewGracePeriod = cachingRenewGracePeriod;
            return this;
        }

        public Builder noCaching() {
            this.cachingRenewGracePeriod = Duration.ZERO;
            return this;
        }

        public VaultStaticClientTokenAuthOptions build() {
            return new VaultStaticClientTokenAuthOptions(this);
        }
    }
}

