/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import io.quarkus.vault.client.auth.VaultAuthOptions;
import io.quarkus.vault.client.auth.VaultAuthRequest;
import io.quarkus.vault.client.auth.VaultCachingTokenProvider;
import io.quarkus.vault.client.auth.unwrap.VaultKeyValueUnwrappingValueProvider;
import io.quarkus.vault.client.auth.unwrap.VaultValueProvider;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class VaultUserPassAuthOptions
extends VaultAuthOptions {
    public final String mountPath;
    public final String username;
    public final Function<VaultAuthRequest, CompletionStage<String>> passwordProvider;

    private VaultUserPassAuthOptions(Builder builder) {
        super(builder.cachingRenewGracePeriod);
        this.mountPath = builder.mountPath;
        this.username = builder.username;
        this.passwordProvider = builder.passwordProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String mountPath = "userpass";
        private String username;
        private Function<VaultAuthRequest, CompletionStage<String>> passwordProvider;
        private Duration cachingRenewGracePeriod = VaultCachingTokenProvider.DEFAULT_RENEW_GRACE_PERIOD;

        public Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.passwordProvider = VaultValueProvider.staticValue(password);
            return this;
        }

        public Builder unwrappingPassword(String wrappingToken, int kvVersion) {
            return this.unwrappingPassword(wrappingToken, "password", kvVersion);
        }

        public Builder unwrappingPassword(String wrappingToken, String kvPath, int kvVersion) {
            this.passwordProvider = new VaultKeyValueUnwrappingValueProvider(wrappingToken, kvPath, kvVersion);
            return this;
        }

        public Builder customPasswordProvider(Function<VaultAuthRequest, CompletionStage<String>> passwordProvider) {
            this.passwordProvider = passwordProvider;
            return this;
        }

        public Builder caching(Duration cachingRenewGracePeriod) {
            this.cachingRenewGracePeriod = cachingRenewGracePeriod;
            return this;
        }

        public Builder noCaching() {
            this.cachingRenewGracePeriod = Duration.ZERO;
            return this;
        }

        public VaultUserPassAuthOptions build() {
            return new VaultUserPassAuthOptions(this);
        }
    }
}

