/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth.unwrap;

import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadSecretData;
import io.quarkus.vault.client.auth.unwrap.VaultUnwrappingValueProvider;
import java.util.Map;

public class VaultKeyValueUnwrappingValueProvider
extends VaultUnwrappingValueProvider<Object> {
    private final String valueKey;
    private final int version;

    public VaultKeyValueUnwrappingValueProvider(String wrappingToken, String valueKey, int version) {
        super(wrappingToken);
        this.valueKey = valueKey;
        this.version = version;
    }

    @Override
    public String getType() {
        return this.valueKey + " in kv(" + this.version + ")";
    }

    @Override
    public Class<?> getUnwrapResultType() {
        return this.version == 1 ? Map.class : VaultSecretsKV2ReadSecretData.class;
    }

    @Override
    public String extractClientToken(Object result) {
        if (this.version == 1) {
            return ((Map)result).get(this.valueKey).toString();
        }
        return ((VaultSecretsKV2ReadSecretData)result).getData().get(this.valueKey).toString();
    }
}

