/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.auth.approle;

import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleCreateCustomSecretIdParams;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleCreateCustomSecretIdResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleGenerateSecretIdParams;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleGenerateSecretIdResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleListRolesResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleListSecretIdAccessorsResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleLoginParams;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleLoginResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleReadRoleIdResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleReadRoleResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleReadSecretIdAccessorResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleReadSecretIdResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleSecretIdAccessorParams;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleSecretIdParams;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleTidyTokensResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleUpdateRoleIdParams;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleUpdateRoleParams;
import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultAuthAppRoleRequestFactory
extends VaultRequestFactory {
    public static final VaultAuthAppRoleRequestFactory INSTANCE = new VaultAuthAppRoleRequestFactory();

    public VaultAuthAppRoleRequestFactory() {
        super("[AUTH (approle)]");
    }

    public VaultRequest<VaultAuthAppRoleLoginResult> login(String mountPath, String roleId, String secretId) {
        return VaultRequest.post(this.getTraceOpName("Login")).path("auth", mountPath, "login").noToken().body(new VaultAuthAppRoleLoginParams().setRoleId(roleId).setSecretId(secretId)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleLoginResult.class));
    }

    public VaultRequest<VaultAuthAppRoleListRolesResult> listRoles(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Roles")).path("auth", mountPath, "role").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleListRolesResult.class));
    }

    public VaultRequest<Void> updateRole(String mountPath, String roleName, VaultAuthAppRoleUpdateRoleParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Role")).path("auth", mountPath, "role", roleName).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthAppRoleReadRoleResult> readRole(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Read Role")).path("auth", mountPath, "role", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleReadRoleResult.class));
    }

    public VaultRequest<Void> deleteRole(String mountPath, String roleName) {
        return VaultRequest.delete(this.getTraceOpName("Delete Role")).path("auth", mountPath, "role", roleName).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthAppRoleReadRoleIdResult> readRoleId(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Read Role Id")).path("auth", mountPath, "role", roleName, "role-id").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleReadRoleIdResult.class));
    }

    public VaultRequest<Void> updateRoleId(String mountPath, String roleName, String roleId) {
        return VaultRequest.post(this.getTraceOpName("Update Role Id")).path("auth", mountPath, "role", roleName, "role-id").body(new VaultAuthAppRoleUpdateRoleIdParams().setRoleId(roleId)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthAppRoleGenerateSecretIdResult> generateSecretId(String mountPath, String roleName, VaultAuthAppRoleGenerateSecretIdParams params) {
        return VaultRequest.post(this.getTraceOpName("Generate Secret Id")).path("auth", mountPath, "role", roleName, "secret-id").body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleGenerateSecretIdResult.class));
    }

    public VaultRequest<VaultAuthAppRoleListSecretIdAccessorsResult> listSecretIdAccessors(String mountPath, String roleName) {
        return VaultRequest.list(this.getTraceOpName("List Secret Id Accessors")).path("auth", mountPath, "role", roleName, "secret-id").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleListSecretIdAccessorsResult.class));
    }

    public VaultRequest<VaultAuthAppRoleReadSecretIdResult> readSecretId(String mountPath, String roleName, String secretId) {
        return VaultRequest.post(this.getTraceOpName("Read Secret Id")).path("auth", mountPath, "role", roleName, "secret-id", "lookup").body(new VaultAuthAppRoleSecretIdParams().setSecretId(secretId)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleReadSecretIdResult.class));
    }

    public VaultRequest<Void> destroySecretId(String mountPath, String roleName, String secretId) {
        return VaultRequest.post(this.getTraceOpName("Destroy Secret Id")).path("auth", mountPath, "role", roleName, "secret-id", "destroy").body(new VaultAuthAppRoleSecretIdParams().setSecretId(secretId)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthAppRoleCreateCustomSecretIdResult> createCustomSecretId(String mountPath, String roleName, VaultAuthAppRoleCreateCustomSecretIdParams params) {
        return VaultRequest.post(this.getTraceOpName("Create new secret ID")).path("auth", mountPath, "role", roleName, "custom-secret-id").body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleCreateCustomSecretIdResult.class));
    }

    public VaultRequest<VaultAuthAppRoleReadSecretIdAccessorResult> readSecretIdAccessor(String mountPath, String roleName, String secretIdAccessor) {
        return VaultRequest.post(this.getTraceOpName("Read Secret Id Accessor")).path("auth", mountPath, "role", roleName, "secret-id-accessor", "lookup").body(new VaultAuthAppRoleSecretIdAccessorParams().setSecretIdAccessor(secretIdAccessor)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleReadSecretIdAccessorResult.class));
    }

    public VaultRequest<Void> destroySecretIdAccessor(String mountPath, String roleName, String secretIdAccessor) {
        return VaultRequest.post(this.getTraceOpName("Destroy Secret Id Accessor")).path("auth", mountPath, "role", roleName, "secret-id-accessor", "destroy").body(new VaultAuthAppRoleSecretIdAccessorParams().setSecretIdAccessor(secretIdAccessor)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthAppRoleTidyTokensResult> tidyTokens(String mountPath) {
        return VaultRequest.post(this.getTraceOpName("Tidy Tokens")).path("auth", mountPath, "tidy", "secret-id").expectOkOrAcceptedStatus().build(VaultLeasedResultExtractor.of(VaultAuthAppRoleTidyTokensResult.class));
    }
}

