/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.rabbitmq;

import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQConfigureConnectionParams;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQGenerateCredentialsResult;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQReadLeaseConfigResultData;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQReadRoleResultData;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQRequestFactory;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQVHosts;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class VaultSecretsRabbitMQ
extends VaultMountableAPI<VaultSecretsRabbitMQRequestFactory> {
    public static VaultSecretsRabbitMQRequestFactory FACTORY = VaultSecretsRabbitMQRequestFactory.INSTANCE;

    public VaultSecretsRabbitMQ(VaultRequestExecutor executor, String mountPath, VaultSecretsRabbitMQRequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultSecretsRabbitMQ(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<Void> configureConnection(VaultSecretsRabbitMQConfigureConnectionParams params) {
        return this.executor.execute(((VaultSecretsRabbitMQRequestFactory)this.factory).configureConnection(this.mountPath, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> configureLease(Duration ttl, Duration maxTtl) {
        return this.executor.execute(((VaultSecretsRabbitMQRequestFactory)this.factory).configureLease(this.mountPath, ttl, maxTtl)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsRabbitMQReadLeaseConfigResultData> readLeaseConfig() {
        return this.executor.execute(((VaultSecretsRabbitMQRequestFactory)this.factory).readLeaseConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> updateRole(String roleName, List<String> tags, VaultSecretsRabbitMQVHosts vhosts, Map<String, VaultSecretsRabbitMQVHosts> vhostTopics) {
        return this.executor.execute(((VaultSecretsRabbitMQRequestFactory)this.factory).updateRole(this.mountPath, roleName, tags, vhosts, vhostTopics)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsRabbitMQReadRoleResultData> readRole(String roleName) {
        return this.executor.execute(((VaultSecretsRabbitMQRequestFactory)this.factory).readRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> deleteRole(String roleName) {
        return this.executor.execute(((VaultSecretsRabbitMQRequestFactory)this.factory).deleteRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsRabbitMQGenerateCredentialsResult> generateCredentials(String roleName) {
        return this.executor.execute(((VaultSecretsRabbitMQRequestFactory)this.factory).generateCredentials(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }
}

