/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.totp;

import io.quarkus.vault.client.api.common.VaultCompletionStages;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPCreateKeyParams;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPCreateKeyResultData;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPGenerateCodeResultData;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPListKeysResultData;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPReadKeyResultData;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPRequestFactory;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPValidateCodeResultData;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public class VaultSecretsTOTP
extends VaultMountableAPI<VaultSecretsTOTPRequestFactory> {
    public static VaultSecretsTOTPRequestFactory FACTORY = VaultSecretsTOTPRequestFactory.INSTANCE;

    public VaultSecretsTOTP(VaultRequestExecutor executor, String mountPath, VaultSecretsTOTPRequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultSecretsTOTP(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<Optional<VaultSecretsTOTPCreateKeyResultData>> createKey(String name, VaultSecretsTOTPCreateKeyParams params) {
        return this.executor.execute(((VaultSecretsTOTPRequestFactory)this.factory).createKey(this.mountPath, name, params)).thenApply(VaultResponse::getResult).thenApply(r -> Optional.ofNullable(r).map(VaultLeasedResult::getData));
    }

    public CompletionStage<VaultSecretsTOTPReadKeyResultData> readKey(String name) {
        return this.executor.execute(((VaultSecretsTOTPRequestFactory)this.factory).readKey(this.mountPath, name)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listKeys() {
        return this.executor.execute(((VaultSecretsTOTPRequestFactory)this.factory).listKeys(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTOTPListKeysResultData)r.getData()).getKeys()).exceptionallyCompose(VaultCompletionStages.recoverNotFound(() -> List.of()));
    }

    public CompletionStage<Void> deleteKey(String name) {
        return this.executor.execute(((VaultSecretsTOTPRequestFactory)this.factory).deleteKey(this.mountPath, name)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<String> generateCode(String name) {
        return this.executor.execute(((VaultSecretsTOTPRequestFactory)this.factory).generateCode(this.mountPath, name)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTOTPGenerateCodeResultData)r.getData()).getCode());
    }

    public CompletionStage<Boolean> validateCode(String name, String code) {
        return this.executor.execute(((VaultSecretsTOTPRequestFactory)this.factory).validateCode(this.mountPath, name, code)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsTOTPValidateCodeResultData)r.getData()).isValid());
    }
}

