/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.transit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsTransitKeyType implements VaultModel
{
    AES128_GCM96("aes128-gcm96"),
    AES256_GCM96("aes256-gcm96"),
    CHACHA20_POLY1305("chacha20-poly1305"),
    ED25519("ed25519"),
    ECDSA_P256("ecdsa-p256"),
    ECDSA_P384("ecdsa-p384"),
    ECDSA_P521("ecdsa-p521"),
    RSA_2048("rsa-2048"),
    RSA_3072("rsa-3072"),
    RSA_4096("rsa-4096"),
    HMAC("hmac"),
    MANAGED_KEY("managed_key");

    private final String value;

    private VaultSecretsTransitKeyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsTransitKeyType from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsTransitKeyType v : VaultSecretsTransitKeyType.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

