/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.auth;

import io.quarkus.vault.client.api.common.VaultAPI;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthEnableConfig;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthFullMethodInfo;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthMethodInfo;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthReadTuneResultData;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthRequestFactory;
import io.quarkus.vault.client.api.sys.auth.VaultSysAuthTuneOptions;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class VaultSysAuth
extends VaultAPI<VaultSysAuthRequestFactory> {
    public static VaultSysAuthRequestFactory FACTORY = VaultSysAuthRequestFactory.INSTANCE;

    public VaultSysAuth(VaultRequestExecutor executor, VaultSysAuthRequestFactory factory) {
        super(executor, factory);
    }

    public VaultSysAuth(VaultRequestExecutor executor) {
        this(executor, FACTORY);
    }

    public CompletionStage<Map<String, VaultSysAuthMethodInfo>> list() {
        return this.executor.execute(((VaultSysAuthRequestFactory)this.factory).list()).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSysAuthFullMethodInfo> read(String path) {
        return this.executor.execute(((VaultSysAuthRequestFactory)this.factory).read(path)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> enable(String path, String type, String description, VaultSysAuthEnableConfig config) {
        return this.executor.execute(((VaultSysAuthRequestFactory)this.factory).enable(path, type, description, config)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> disable(String path) {
        return this.executor.execute(((VaultSysAuthRequestFactory)this.factory).disable(path)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSysAuthReadTuneResultData> readTune(String path) {
        return this.executor.execute(((VaultSysAuthRequestFactory)this.factory).readTune(path)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> tune(String path, VaultSysAuthTuneOptions options) {
        return this.executor.execute(((VaultSysAuthRequestFactory)this.factory).tune(path, options)).thenApply(VaultResponse::getResult);
    }
}

