/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.mounts;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsEnableConfig;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsEnableParams;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsListResult;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsReadResult;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsReadTuneResult;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsTuneParams;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import java.util.Map;

public class VaultSysMountsRequestFactory
extends VaultRequestFactory {
    public static final VaultSysMountsRequestFactory INSTANCE = new VaultSysMountsRequestFactory();

    public VaultSysMountsRequestFactory() {
        super("[SYS (mounts)]");
    }

    public VaultRequest<VaultSysMountsListResult> list() {
        return VaultRequest.get(this.getTraceOpName("List")).path("sys", "mounts").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysMountsListResult.class));
    }

    public VaultRequest<VaultSysMountsReadResult> read(String path) {
        return VaultRequest.get(this.getTraceOpName("Read")).path("sys", "mounts", path).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysMountsReadResult.class));
    }

    public VaultRequest<Void> enable(String path, String type, String description, VaultSysMountsEnableConfig config, Map<String, Object> options) {
        return VaultRequest.post(this.getTraceOpName("Enable")).path("sys", "mounts", path).body(new VaultSysMountsEnableParams().setType(type).setDescription(description).setConfig(config).setOptions(options)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> disable(String path) {
        return VaultRequest.delete(this.getTraceOpName("Disable")).path("sys", "mounts", path).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSysMountsReadTuneResult> readTune(String path) {
        return VaultRequest.get(this.getTraceOpName("Read Tune")).path("sys", "mounts", path, "tune").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysMountsReadTuneResult.class));
    }

    public VaultRequest<Void> tune(String path, VaultSysMountsTuneParams params) {
        return VaultRequest.post(this.getTraceOpName("Tune")).path("sys", "mounts", path, "tune").body(params).expectNoContentStatus().build();
    }
}

