/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.tools;

import io.quarkus.vault.client.api.common.VaultAPI;
import io.quarkus.vault.client.api.common.VaultFormat;
import io.quarkus.vault.client.api.common.VaultHashAlgorithm;
import io.quarkus.vault.client.api.common.VaultRandomSource;
import io.quarkus.vault.client.api.sys.tools.VaultSysToolsHashResultData;
import io.quarkus.vault.client.api.sys.tools.VaultSysToolsRandomData;
import io.quarkus.vault.client.api.sys.tools.VaultSysToolsRequestFactory;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.concurrent.CompletionStage;

public class VaultSysTools
extends VaultAPI<VaultSysToolsRequestFactory> {
    public static VaultSysToolsRequestFactory FACTORY = VaultSysToolsRequestFactory.INSTANCE;

    public VaultSysTools(VaultRequestExecutor executor, VaultSysToolsRequestFactory factory) {
        super(executor, factory);
    }

    public VaultSysTools(VaultRequestExecutor executor) {
        this(executor, FACTORY);
    }

    public CompletionStage<byte[]> random(Integer bytes, VaultRandomSource source, VaultFormat format) {
        return this.executor.execute(((VaultSysToolsRequestFactory)this.factory).random(bytes, source, format)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSysToolsRandomData)r.getData()).getBytes(format));
    }

    public CompletionStage<String> hash(VaultHashAlgorithm algorithm, byte[] input, VaultFormat format) {
        return this.executor.execute(((VaultSysToolsRequestFactory)this.factory).hash(algorithm, input, format)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSysToolsHashResultData)r.getData()).getSum());
    }
}

