/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import io.quarkus.vault.client.auth.VaultTimeLimited;
import io.quarkus.vault.client.auth.VaultTokenException;
import io.quarkus.vault.client.logging.LogConfidentialityLevel;
import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;
import java.util.concurrent.atomic.AtomicInteger;

public class VaultToken
extends VaultTimeLimited {
    private final String clientToken;
    private final boolean fromCache;
    private final AtomicInteger allowedUsesRemaining;

    public static VaultToken from(String clientToken, boolean renewable, Duration leaseDuration, Integer allowedUsesRemaining, InstantSource instantSource) {
        return new VaultToken(clientToken, renewable, leaseDuration, allowedUsesRemaining, false, instantSource);
    }

    public static VaultToken renewable(String clientToken, Duration leaseDuration, Integer allowedUsesRemaining, InstantSource instantSource) {
        return VaultToken.from(clientToken, true, leaseDuration, allowedUsesRemaining, instantSource);
    }

    public static VaultToken neverExpires(String clientToken, InstantSource instantSource) {
        return VaultToken.from(clientToken, false, Duration.ofSeconds(Long.MAX_VALUE), null, instantSource);
    }

    public VaultToken(String clientToken, boolean renewable, Duration leaseDuration, Integer allowedUsesRemaining, boolean fromCache, InstantSource instantSource) {
        super(renewable, leaseDuration, instantSource);
        this.clientToken = clientToken;
        this.fromCache = fromCache;
        this.allowedUsesRemaining = new AtomicInteger(allowedUsesRemaining != null && allowedUsesRemaining > 0 ? allowedUsesRemaining : Integer.MAX_VALUE);
    }

    public VaultToken(String clientToken, boolean renewable, Duration leaseDuration, Instant created, boolean fromCache, AtomicInteger allowedUsesRemaining, InstantSource instantSource) {
        super(renewable, leaseDuration, created, instantSource);
        this.clientToken = clientToken;
        this.fromCache = fromCache;
        this.allowedUsesRemaining = allowedUsesRemaining;
    }

    public VaultToken cached() {
        return new VaultToken(this.clientToken, this.isRenewable(), this.getLeaseDuration(), this.getCreated(), true, this.allowedUsesRemaining, this.getInstantSource());
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public int getAllowedUsesRemaining() {
        return this.allowedUsesRemaining.get();
    }

    public boolean hasAllowedUsesRemaining() {
        return this.allowedUsesRemaining.get() > 0;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }

    public String getClientTokenForUsage() {
        int remainingUses = this.allowedUsesRemaining.updateAndGet(remaining -> Math.max(remaining - 1, -1));
        if (remainingUses == -1) {
            throw new VaultTokenException(VaultTokenException.Reason.TOKEN_USES_EXHAUSTED);
        }
        return this.clientToken;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.hasAllowedUsesRemaining();
    }

    public String getConfidentialInfo(LogConfidentialityLevel level) {
        return "{clientToken: " + level.maskWithTolerance(this.clientToken, LogConfidentialityLevel.LOW) + ", " + super.info() + "}";
    }
}

