/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPass;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassLoginAuthResult;
import io.quarkus.vault.client.auth.VaultAuthRequest;
import io.quarkus.vault.client.auth.VaultToken;
import io.quarkus.vault.client.auth.VaultTokenProvider;
import io.quarkus.vault.client.auth.VaultUserPassAuthOptions;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class VaultUserPassTokenProvider
implements VaultTokenProvider {
    private final String mountPath;
    private final String username;
    private final Function<VaultAuthRequest, CompletionStage<String>> passwordProvider;

    public VaultUserPassTokenProvider(String mountPath, String username, Function<VaultAuthRequest, CompletionStage<String>> passwordProvider) {
        this.mountPath = mountPath;
        this.username = username;
        this.passwordProvider = passwordProvider;
    }

    public VaultUserPassTokenProvider(VaultUserPassAuthOptions options) {
        this(options.mountPath, options.username, options.passwordProvider);
    }

    @Override
    public CompletionStage<VaultToken> apply(VaultAuthRequest authRequest) {
        VaultRequestExecutor executor = authRequest.getExecutor();
        return this.passwordProvider.apply(authRequest).thenCompose(password -> executor.execute(VaultAuthUserPass.FACTORY.login(this.mountPath, this.username, (String)password)).thenApply(VaultResponse::getResult).thenApply(res -> {
            VaultAuthUserPassLoginAuthResult auth = (VaultAuthUserPassLoginAuthResult)res.getAuth();
            return VaultToken.from(auth.getClientToken(), auth.isRenewable(), auth.getLeaseDuration(), auth.getNumUses(), authRequest.getInstantSource());
        }));
    }
}

