/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.http.jdk;

import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.http.VaultHttpClient;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;

public class JDKVaultHttpClient
extends VaultHttpClient {
    private final HttpClient httpClient;

    public JDKVaultHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public <T> CompletionStage<VaultResponse<T>> execute(VaultRequest<T> request) {
        return CompletableFuture.completedStage(request).thenApply(this::buildHTTPRequest).thenCompose(httpRequest -> this.httpClient.sendAsync((HttpRequest)httpRequest, HttpResponse.BodyHandlers.ofByteArray())).exceptionallyCompose(JDKVaultHttpClient::mapError).thenCompose(res -> this.buildResponse(request, res.statusCode(), JDKVaultHttpClient.headers(res), (byte[])res.body()));
    }

    private HttpRequest buildHTTPRequest(VaultRequest<?> request) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(request.getUri()).timeout(request.getTimeout());
        request.getHTTPHeaders().forEach(requestBuilder::header);
        HttpRequest.BodyPublisher body = request.getSerializedBody().map(HttpRequest.BodyPublishers::ofString).orElseGet(HttpRequest.BodyPublishers::noBody);
        return requestBuilder.method(request.getMethod().name(), body).build();
    }

    private static <T> CompletionStage<HttpResponse<T>> mapError(Throwable x) {
        if (x instanceof HttpConnectTimeoutException) {
            return CompletableFuture.failedStage(new TimeoutException("HTTP connect time out: " + x.getMessage()));
        }
        if (x instanceof HttpTimeoutException) {
            return CompletableFuture.failedStage(new TimeoutException("HTTP request time out: " + x.getMessage()));
        }
        if (x instanceof CompletionException) {
            Throwable cause = x.getCause();
            if (cause instanceof HttpConnectTimeoutException) {
                return CompletableFuture.failedStage(new TimeoutException("HTTP connect time out: " + cause.getMessage()));
            }
            if (cause instanceof HttpTimeoutException) {
                return CompletableFuture.failedStage(new TimeoutException("HTTP request time out: " + cause.getMessage()));
            }
        }
        return CompletableFuture.failedStage(x);
    }

    private static List<Map.Entry<String, String>> headers(HttpResponse<?> response) {
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        response.headers().map().forEach((key, values) -> values.forEach(value -> headers.add(Map.entry(key, value))));
        return headers;
    }

    @Override
    public void close() {
    }
}

