/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.vault.VaultTOTPSecretReactiveEngine;
import io.quarkus.vault.secrets.totp.CreateKeyParameters;
import io.quarkus.vault.secrets.totp.KeyConfiguration;
import io.quarkus.vault.secrets.totp.KeyDefinition;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class VaultTOTPSecretEngine {
    private final VaultTOTPSecretReactiveEngine engine;

    @Inject
    public VaultTOTPSecretEngine(VaultTOTPSecretReactiveEngine engine) {
        this.engine = engine;
    }

    public Optional<KeyDefinition> createKey(String name, CreateKeyParameters createKeyParameters) {
        return (Optional)this.engine.createKey(name, createKeyParameters).await().indefinitely();
    }

    public KeyConfiguration readKey(String name) {
        return (KeyConfiguration)this.engine.readKey(name).await().indefinitely();
    }

    public List<String> listKeys() {
        return (List)this.engine.listKeys().await().indefinitely();
    }

    public void deleteKey(String name) {
        this.engine.deleteKey(name).await().indefinitely();
    }

    public String generateCode(String name) {
        return (String)this.engine.generateCode(name).await().indefinitely();
    }

    public boolean validateCode(String name, String code) {
        return (Boolean)this.engine.validateCode(name, code).await().indefinitely();
    }
}

