/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.pki;

import io.quarkus.vault.pki.DataFormat;
import io.quarkus.vault.pki.X509Parsing;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public interface CAChainData {
    public DataFormat getFormat();

    public Object getData();

    public List<X509Certificate> getCertificates() throws CertificateException;

    public static class PEM
    implements CAChainData {
        private final String pemData;

        public PEM(String pemData) {
            this.pemData = pemData;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.PEM;
        }

        @Override
        public String getData() {
            return this.pemData;
        }

        @Override
        public List<X509Certificate> getCertificates() throws CertificateException {
            return X509Parsing.parsePEMCertificates(this.pemData);
        }
    }

    public static class DER
    implements CAChainData {
        private final byte[] derData;

        public DER(byte[] derData) {
            this.derData = derData;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.DER;
        }

        public byte[] getData() {
            return this.derData;
        }

        @Override
        public List<X509Certificate> getCertificates() throws CertificateException {
            return X509Parsing.parseDERCertificates(this.derData);
        }
    }
}

