/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.backend;

import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.sys.VaultEnableEngineBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultHealthResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultInitBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultInitResponse;
import io.quarkus.vault.runtime.client.dto.sys.VaultLeasesBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultLeasesLookup;
import io.quarkus.vault.runtime.client.dto.sys.VaultListPolicyResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultRenewLease;
import io.quarkus.vault.runtime.client.dto.sys.VaultSealStatusResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultSecretEngineInfoResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultTuneBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultTuneResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultUnwrapBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultWrapResult;
import io.smallrye.mutiny.Uni;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class VaultInternalSystemBackend
extends VaultInternalBase {
    @Override
    protected String opNamePrefix() {
        return super.opNamePrefix() + " [SYS]";
    }

    public Uni<Integer> systemHealth(VaultClient vaultClient, boolean isStandByOk, boolean isPerfStandByOk) {
        Map<String, String> queryParams = this.getHealthParams(isStandByOk, isPerfStandByOk);
        return vaultClient.head(this.opName("Health"), "sys/health", queryParams);
    }

    public Uni<VaultHealthResult> systemHealthStatus(VaultClient vaultClient, boolean isStandByOk, boolean isPerfStandByOk) {
        Map<String, String> queryParams = this.getHealthParams(isStandByOk, isPerfStandByOk);
        return vaultClient.get(this.opName("Health Status"), "sys/health", queryParams, VaultHealthResult.class);
    }

    public Uni<VaultSealStatusResult> systemSealStatus(VaultClient vaultClient) {
        return vaultClient.get(this.opName("Seal Status"), "sys/seal-status", Collections.emptyMap(), VaultSealStatusResult.class);
    }

    public Uni<VaultInitResponse> init(VaultClient vaultClient, int secretShares, int secretThreshold) {
        VaultInitBody body = new VaultInitBody(secretShares, secretThreshold);
        return vaultClient.put(this.opName("Initialize"), "sys/init", body, VaultInitResponse.class);
    }

    public Uni<VaultWrapResult> wrap(VaultClient vaultClient, String token, long ttl, Object object) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Vault-Wrap-TTL", "" + ttl);
        return vaultClient.post(this.opName("Wrap"), "sys/wrapping/wrap", token, headers, object, VaultWrapResult.class);
    }

    public <T> Uni<T> unwrap(VaultClient vaultClient, String wrappingToken, Class<T> resultClass) {
        return vaultClient.post(this.opName("Unwrap"), "sys/wrapping/unwrap", wrappingToken, (Object)VaultUnwrapBody.EMPTY, resultClass);
    }

    public Uni<VaultPolicyResult> getPolicy(VaultClient vaultClient, String token, String name) {
        return vaultClient.get(this.opName("Get Policy"), "sys/policy/" + name, token, VaultPolicyResult.class);
    }

    public Uni<Void> createUpdatePolicy(VaultClient vaultClient, String token, String name, VaultPolicyBody body) {
        return vaultClient.put(this.opName("Update Policy"), "sys/policy/" + name, token, (Object)body, 204);
    }

    public Uni<VaultListPolicyResult> listPolicies(VaultClient vaultClient, String token) {
        return vaultClient.get(this.opName("List Policies"), "sys/policy", token, VaultListPolicyResult.class);
    }

    public Uni<Void> deletePolicy(VaultClient vaultClient, String token, String name) {
        return vaultClient.delete(this.opName("Delete Policy"), "sys/policy/" + name, token, 204);
    }

    public Uni<VaultLeasesLookup> lookupLease(VaultClient vaultClient, String token, String leaseId) {
        VaultLeasesBody body = new VaultLeasesBody(leaseId);
        return vaultClient.put(this.opName("Lookup Lease"), "sys/leases/lookup", token, (Object)body, VaultLeasesLookup.class);
    }

    public Uni<VaultRenewLease> renewLease(VaultClient vaultClient, String token, String leaseId) {
        VaultLeasesBody body = new VaultLeasesBody(leaseId);
        return vaultClient.put(this.opName("Renew Lease"), "sys/leases/renew", token, (Object)body, VaultRenewLease.class);
    }

    public Uni<Void> enableEngine(VaultClient vaultClient, String token, String mount, VaultEnableEngineBody body) {
        return vaultClient.post(this.opName("Enable Engine"), "sys/mounts/" + mount, token, (Object)body, 204);
    }

    public Uni<Void> disableEngine(VaultClient vaultClient, String token, String mount) {
        return vaultClient.delete(this.opName("Disable Engine"), "sys/mounts/" + mount, token, 204);
    }

    public Uni<VaultTuneResult> getTuneInfo(VaultClient vaultClient, String token, String mount) {
        return vaultClient.get(this.opName("Tune Info"), "sys/mounts/" + mount + "/tune", token, VaultTuneResult.class);
    }

    public Uni<Void> updateTuneInfo(VaultClient vaultClient, String token, String mount, VaultTuneBody body) {
        return vaultClient.post(this.opName("Tune"), "sys/mounts/" + mount + "/tune", token, (Object)body, 204);
    }

    public Uni<VaultSecretEngineInfoResult> getSecretEngineInfo(VaultClient vaultClient, String token, String mount) {
        return vaultClient.get(this.opName("Engine Info"), "sys/mounts/" + mount, token, VaultSecretEngineInfoResult.class);
    }

    private Map<String, String> getHealthParams(boolean isStandByOk, boolean isPerfStandByOk) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (isStandByOk) {
            queryParams.put("standbyok", "true");
        }
        if (isPerfStandByOk) {
            queryParams.put("perfstandbyok", "true");
        }
        return queryParams;
    }
}

