/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.vault.transit.ClearData;
import io.quarkus.vault.transit.DecryptionRequest;
import io.quarkus.vault.transit.EncryptionRequest;
import io.quarkus.vault.transit.KeyConfigRequestDetail;
import io.quarkus.vault.transit.KeyCreationRequestDetail;
import io.quarkus.vault.transit.RewrappingRequest;
import io.quarkus.vault.transit.SignVerifyOptions;
import io.quarkus.vault.transit.SigningInput;
import io.quarkus.vault.transit.SigningRequest;
import io.quarkus.vault.transit.TransitContext;
import io.quarkus.vault.transit.VaultTransitExportKeyType;
import io.quarkus.vault.transit.VaultTransitKeyDetail;
import io.quarkus.vault.transit.VaultTransitKeyExportDetail;
import io.quarkus.vault.transit.VerificationRequest;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface VaultTransitSecretReactiveEngine {
    public Uni<String> encrypt(String var1, String var2);

    public Uni<String> encrypt(String var1, ClearData var2, TransitContext var3);

    public Uni<Map<EncryptionRequest, String>> encrypt(String var1, List<EncryptionRequest> var2);

    public Uni<ClearData> decrypt(String var1, String var2);

    public Uni<ClearData> decrypt(String var1, String var2, TransitContext var3);

    public Uni<Map<DecryptionRequest, ClearData>> decrypt(String var1, List<DecryptionRequest> var2);

    public Uni<String> rewrap(String var1, String var2);

    public Uni<String> rewrap(String var1, String var2, TransitContext var3);

    public Uni<Map<RewrappingRequest, String>> rewrap(String var1, List<RewrappingRequest> var2);

    public Uni<String> sign(String var1, String var2);

    public Uni<String> sign(String var1, SigningInput var2, TransitContext var3);

    public Uni<String> sign(String var1, SigningInput var2, SignVerifyOptions var3, TransitContext var4);

    public Uni<Map<SigningRequest, String>> sign(String var1, List<SigningRequest> var2);

    public Uni<Map<SigningRequest, String>> sign(String var1, List<SigningRequest> var2, SignVerifyOptions var3);

    public Uni<Void> verifySignature(String var1, String var2, String var3);

    public Uni<Void> verifySignature(String var1, String var2, SigningInput var3, TransitContext var4);

    public Uni<Void> verifySignature(String var1, String var2, SigningInput var3, SignVerifyOptions var4, TransitContext var5);

    public Uni<Void> verifySignature(String var1, List<VerificationRequest> var2);

    public Uni<Void> verifySignature(String var1, List<VerificationRequest> var2, SignVerifyOptions var3);

    public Uni<Void> createKey(String var1, KeyCreationRequestDetail var2);

    public Uni<Void> updateKeyConfiguration(String var1, KeyConfigRequestDetail var2);

    public Uni<Void> deleteKey(String var1);

    public Uni<VaultTransitKeyExportDetail> exportKey(String var1, VaultTransitExportKeyType var2, String var3);

    public Uni<Optional<VaultTransitKeyDetail<?>>> readKey(String var1);

    public Uni<List<String>> listKeys();
}

