/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultAppRoleAuthReactiveService;
import io.quarkus.vault.auth.VaultAppRoleAuthRole;
import io.quarkus.vault.auth.VaultAppRoleSecretId;
import io.quarkus.vault.auth.VaultAppRoleSecretIdAccessor;
import io.quarkus.vault.auth.VaultAppRoleSecretIdRequest;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.authmethod.VaultInternalAppRoleAuthMethod;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthCreateCustomSecretIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthCreateSecretIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthListRolesData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthListSecretIdAccessorsData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthReadSecretIdAccessorData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthReadSecretIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthRoleData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthRoleIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthSecretIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleGenerateNewSecretIDData;
import io.smallrye.mutiny.Uni;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class VaultAppRoleAuthManager
implements VaultAppRoleAuthReactiveService {
    @Inject
    private VaultClient vaultClient;
    @Inject
    private VaultAuthManager vaultAuthManager;
    @Inject
    private VaultInternalAppRoleAuthMethod vaultInternalAppRoleAuthMethod;

    @Override
    public Uni<List<String>> getAppRoles() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalAppRoleAuthMethod.listAuthRoles(this.vaultClient, (String)token).map(r -> ((VaultAppRoleAuthListRolesData)r.data).keys).onFailure(VaultClientException.class).recoverWithUni(e -> {
            if (((VaultClientException)e).getStatus() == 404) {
                return Uni.createFrom().item(Collections.emptyList());
            }
            return Uni.createFrom().failure(e);
        }));
    }

    @Override
    public Uni<Void> createOrUpdateAppRole(String name, VaultAppRoleAuthRole role) {
        VaultAppRoleAuthRoleData body = new VaultAppRoleAuthRoleData().setBindSecretId(role.bindSecretId).setSecretIdBoundCidrs(role.secretIdBoundCidrs).setSecretIdNumUses(role.secretIdNumUses).setSecretIdTtl(role.secretIdTtl).setLocalSecretIds(role.localSecretIds).setTokenTtl(role.tokenTtl).setTokenMaxTtl(role.tokenMaxTtl).setTokenPolicies(role.tokenPolicies).setTokenBoundCidrs(role.tokenBoundCidrs).setTokenExplicitMaxTtl(role.tokenExplicitMaxTtl).setTokenNoDefaultPolicy(role.tokenNoDefaultPolicy).setTokenNumUses(role.tokenNumUses).setTokenPeriod(role.tokenPeriod).setTokenType(role.tokenType);
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalAppRoleAuthMethod.createAuthRole(this.vaultClient, (String)token, name, body));
    }

    @Override
    public Uni<Void> deleteAppRole(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalAppRoleAuthMethod.deleteAuthRoles(this.vaultClient, (String)token, name));
    }

    @Override
    public Uni<VaultAppRoleAuthRole> getAppRole(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalAppRoleAuthMethod.getVaultAuthRole(this.vaultClient, (String)token, name).map(result -> {
            VaultAppRoleAuthRoleData role = (VaultAppRoleAuthRoleData)result.data;
            return new VaultAppRoleAuthRole().setBindSecretId(role.bindSecretId).setSecretIdBoundCidrs(role.secretIdBoundCidrs).setSecretIdNumUses(role.secretIdNumUses).setSecretIdTtl(role.secretIdTtl).setLocalSecretIds(role.localSecretIds).setTokenTtl(role.tokenTtl).setTokenMaxTtl(role.tokenMaxTtl).setTokenPolicies(role.tokenPolicies).setTokenBoundCidrs(role.tokenBoundCidrs).setTokenExplicitMaxTtl(role.tokenExplicitMaxTtl).setTokenNoDefaultPolicy(role.tokenNoDefaultPolicy).setTokenNumUses(role.tokenNumUses).setTokenPeriod(role.tokenPeriod).setTokenType(role.tokenType);
        }));
    }

    @Override
    public Uni<String> getAppRoleRoleId(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalAppRoleAuthMethod.getRoleId(this.vaultClient, (String)token, name).map(result -> ((VaultAppRoleAuthRoleIdData)result.data).roleId));
    }

    @Override
    public Uni<Void> setAppRoleRoleId(String name, String roleId) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            VaultAppRoleAuthRoleIdData body = new VaultAppRoleAuthRoleIdData().setRoleId(roleId);
            return this.vaultInternalAppRoleAuthMethod.setRoleId(this.vaultClient, (String)token, name, body);
        });
    }

    @Override
    public Uni<VaultAppRoleSecretId> createNewSecretId(String name, VaultAppRoleSecretIdRequest newSecretIdRequest) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            VaultAppRoleAuthCreateSecretIdData body = new VaultAppRoleAuthCreateSecretIdData().setCidrList(newSecretIdRequest.cidrList).setTokenBoundCidrs(newSecretIdRequest.tokenBoundCidrs).setMetadata(newSecretIdRequest.metadata);
            return this.vaultInternalAppRoleAuthMethod.createSecretId(this.vaultClient, (String)token, name, body).map(result -> new VaultAppRoleSecretId().setSecretId(((VaultAppRoleGenerateNewSecretIDData)result.data).secretId).setSecretIdAccessor(((VaultAppRoleGenerateNewSecretIDData)result.data).secretIdAccessor));
        });
    }

    @Override
    public Uni<VaultAppRoleSecretId> createCustomSecretId(String name, VaultAppRoleSecretIdRequest newSecretIdRequest) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            VaultAppRoleAuthCreateCustomSecretIdData body = new VaultAppRoleAuthCreateCustomSecretIdData().setSecretId(newSecretIdRequest.secretId).setCidrList(newSecretIdRequest.cidrList).setTokenBoundCidrs(newSecretIdRequest.tokenBoundCidrs).setMetadata(newSecretIdRequest.metadata);
            return this.vaultInternalAppRoleAuthMethod.createCustomSecretId(this.vaultClient, (String)token, name, body).map(result -> new VaultAppRoleSecretId().setSecretId(((VaultAppRoleGenerateNewSecretIDData)result.data).secretId).setSecretIdAccessor(((VaultAppRoleGenerateNewSecretIDData)result.data).secretIdAccessor));
        });
    }

    @Override
    public Uni<List<String>> getSecretIdAccessors(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalAppRoleAuthMethod.listSecretIdAccessors(this.vaultClient, (String)token, name).map(r -> ((VaultAppRoleAuthListSecretIdAccessorsData)r.data).keys).onFailure(VaultClientException.class).recoverWithUni(e -> {
            if (((VaultClientException)e).getStatus() == 404) {
                return Uni.createFrom().item(Collections.emptyList());
            }
            return Uni.createFrom().failure(e);
        }));
    }

    @Override
    public Uni<VaultAppRoleSecretIdAccessor> getSecretIdAccessor(String name, String accessorId) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            VaultAppRoleAuthReadSecretIdAccessorData body = new VaultAppRoleAuthReadSecretIdAccessorData().setSecretIdAccessor(accessorId);
            return this.vaultInternalAppRoleAuthMethod.readSecretIdAccessor(this.vaultClient, (String)token, name, body).map(result -> new VaultAppRoleSecretIdAccessor().setCreationTime(((VaultAppRoleAuthSecretIdData)result.data).creationTime).setLastUpdatedTime(((VaultAppRoleAuthSecretIdData)result.data).lastUpdatedTime).setExpirationTime(((VaultAppRoleAuthSecretIdData)result.data).expirationTime).setSecretIdAccessor(((VaultAppRoleAuthSecretIdData)result.data).secretIdAccessor).setMetadata(((VaultAppRoleAuthSecretIdData)result.data).metadata).setCidrList(((VaultAppRoleAuthSecretIdData)result.data).cidrList).setSecretIdNumUses(((VaultAppRoleAuthSecretIdData)result.data).secretIdNumUses).setSecretIdTtl(((VaultAppRoleAuthSecretIdData)result.data).secretIdTtl).setTokenBoundCidrs(((VaultAppRoleAuthSecretIdData)result.data).tokenBoundCidrs));
        });
    }

    @Override
    public Uni<Void> deleteSecretIdAccessor(String name, String accessorId) {
        VaultAppRoleAuthReadSecretIdAccessorData body = new VaultAppRoleAuthReadSecretIdAccessorData().setSecretIdAccessor(accessorId);
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalAppRoleAuthMethod.deleteSecretIdAccessor(this.vaultClient, (String)token, name, body));
    }

    @Override
    public Uni<VaultAppRoleSecretIdAccessor> getSecretId(String name, String secretId) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            VaultAppRoleAuthReadSecretIdData body = new VaultAppRoleAuthReadSecretIdData().setSecretId(secretId);
            return this.vaultInternalAppRoleAuthMethod.readSecretId(this.vaultClient, (String)token, name, body).map(result -> new VaultAppRoleSecretIdAccessor().setCreationTime(((VaultAppRoleAuthSecretIdData)result.data).creationTime).setLastUpdatedTime(((VaultAppRoleAuthSecretIdData)result.data).lastUpdatedTime).setExpirationTime(((VaultAppRoleAuthSecretIdData)result.data).expirationTime).setSecretIdAccessor(((VaultAppRoleAuthSecretIdData)result.data).secretIdAccessor).setMetadata(((VaultAppRoleAuthSecretIdData)result.data).metadata).setCidrList(((VaultAppRoleAuthSecretIdData)result.data).cidrList).setSecretIdNumUses(((VaultAppRoleAuthSecretIdData)result.data).secretIdNumUses).setSecretIdTtl(((VaultAppRoleAuthSecretIdData)result.data).secretIdTtl).setTokenBoundCidrs(((VaultAppRoleAuthSecretIdData)result.data).tokenBoundCidrs));
        });
    }

    @Override
    public Uni<Void> deleteSecretId(String name, String secretId) {
        VaultAppRoleAuthReadSecretIdData body = new VaultAppRoleAuthReadSecretIdData().setSecretId(secretId);
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalAppRoleAuthMethod.deleteSecretId(this.vaultClient, (String)token, name, body));
    }
}

