/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import io.quarkus.vault.runtime.config.VaultConfigSourceProvider;
import java.lang.annotation.Annotation;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

@Recorder
public class VaultRecorder {
    private static final EmptyConfigSourceProvider EMPTY = new EmptyConfigSourceProvider();

    public RuntimeValue<ConfigSourceProvider> configure(VaultBootstrapConfig vaultBootstrapConfig) {
        Object configSourceProvider = EMPTY;
        if (vaultBootstrapConfig.url.isPresent()) {
            ArcContainer container = Arc.container();
            ((VaultConfigHolder)container.instance(VaultConfigHolder.class, new Annotation[0]).get()).setVaultBootstrapConfig(vaultBootstrapConfig);
            configSourceProvider = new VaultConfigSourceProvider(vaultBootstrapConfig);
        }
        return new RuntimeValue(configSourceProvider);
    }

    private static class EmptyConfigSourceProvider
    implements ConfigSourceProvider {
        private EmptyConfigSourceProvider() {
        }

        public Iterable<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return Collections.emptyList();
        }
    }
}

