/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.authmethod;

import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuth;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthBody;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthCreateCustomSecretIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthCreateSecretIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthListRolesResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthListSecretIdAccessorsResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthReadRoleResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthReadSecretIdAccessorData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthReadSecretIdAccessorResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthReadSecretIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthReadSecretIdResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthRoleData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthRoleIdData;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthSetRoleIdResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleGenerateNewSecretID;
import io.smallrye.mutiny.Uni;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class VaultInternalAppRoleAuthMethod
extends VaultInternalBase {
    @Inject
    private VaultConfigHolder vaultConfigHolder;

    @Override
    protected String opNamePrefix() {
        return super.opNamePrefix() + " [AUTH (approle)]";
    }

    public Uni<VaultAppRoleAuth> login(VaultClient vaultClient, String roleId, String secretId) {
        VaultAppRoleAuthBody body = new VaultAppRoleAuthBody(roleId, secretId);
        return vaultClient.post(this.opName("Login"), this.getAppRoleAuthMountPath() + "/login", null, (Object)body, VaultAppRoleAuth.class);
    }

    public Uni<Void> createAuthRole(VaultClient vaultClient, String token, String name, VaultAppRoleAuthRoleData body) {
        return vaultClient.post(this.opName("Create Role"), this.getAppRoleAuthMountPath() + "/role/" + name, token, (Object)body, 204);
    }

    private String getAppRoleAuthMountPath() {
        return this.vaultConfigHolder.getVaultBootstrapConfig().authentication.appRole.authMountPath;
    }

    public Uni<VaultAppRoleAuthReadRoleResult> getVaultAuthRole(VaultClient vaultClient, String token, String name) {
        return vaultClient.get(this.opName("Get Role"), this.getAppRoleAuthMountPath() + "/role/" + name, token, VaultAppRoleAuthReadRoleResult.class);
    }

    public Uni<VaultAppRoleAuthListRolesResult> listAuthRoles(VaultClient vaultClient, String token) {
        return vaultClient.list(this.opName("List Roles"), this.getAppRoleAuthMountPath() + "/role", token, VaultAppRoleAuthListRolesResult.class);
    }

    public Uni<Void> deleteAuthRoles(VaultClient vaultClient, String token, String name) {
        return vaultClient.delete(this.opName("Delete Role"), this.getAppRoleAuthMountPath() + "/role/" + name, token, 204);
    }

    public Uni<VaultAppRoleAuthSetRoleIdResult> getRoleId(VaultClient vaultClient, String token, String name) {
        return vaultClient.get(this.opName("Get Role ID"), this.getAppRoleAuthMountPath() + "/role/" + name + "/role-id", token, VaultAppRoleAuthSetRoleIdResult.class);
    }

    public Uni<Void> setRoleId(VaultClient vaultClient, String token, String name, VaultAppRoleAuthRoleIdData body) {
        return vaultClient.post(this.opName("Set Role ID"), this.getAppRoleAuthMountPath() + "/role/" + name + "/role-id", token, (Object)body, 204);
    }

    public Uni<VaultAppRoleGenerateNewSecretID> createSecretId(VaultClient vaultClient, String token, String name, VaultAppRoleAuthCreateSecretIdData body) {
        return vaultClient.post(this.opName("Create new secret ID"), this.getAppRoleAuthMountPath() + "/role/" + name + "/secret-id", token, (Object)body, VaultAppRoleGenerateNewSecretID.class);
    }

    public Uni<VaultAppRoleAuthReadSecretIdResult> readSecretId(VaultClient vaultClient, String token, String name, VaultAppRoleAuthReadSecretIdData body) {
        return vaultClient.post(this.opName("Read secret ID"), this.getAppRoleAuthMountPath() + "/role/" + name + "/secret-id/lookup", token, (Object)body, VaultAppRoleAuthReadSecretIdResult.class);
    }

    public Uni<Void> deleteSecretId(VaultClient vaultClient, String token, String name, VaultAppRoleAuthReadSecretIdData body) {
        return vaultClient.post(this.opName("Delete secret ID"), this.getAppRoleAuthMountPath() + "/role/" + name + "/secret-id/destroy", token, (Object)body, 204);
    }

    public Uni<VaultAppRoleGenerateNewSecretID> createCustomSecretId(VaultClient vaultClient, String token, String name, VaultAppRoleAuthCreateCustomSecretIdData body) {
        return vaultClient.post(this.opName("Create new secret ID"), this.getAppRoleAuthMountPath() + "/role/" + name + "/custom-secret-id", token, (Object)body, VaultAppRoleGenerateNewSecretID.class);
    }

    public Uni<VaultAppRoleAuthListSecretIdAccessorsResult> listSecretIdAccessors(VaultClient vaultClient, String token, String name) {
        return vaultClient.list(this.opName("List secret ID accessors"), this.getAppRoleAuthMountPath() + "/role/" + name + "/secret-id", token, VaultAppRoleAuthListSecretIdAccessorsResult.class);
    }

    public Uni<VaultAppRoleAuthReadSecretIdAccessorResult> readSecretIdAccessor(VaultClient vaultClient, String token, String name, VaultAppRoleAuthReadSecretIdAccessorData body) {
        return vaultClient.list(this.opName("Read secret ID accessor"), this.getAppRoleAuthMountPath() + "/role/" + name + "/secret-id-accessor/lookup", token, VaultAppRoleAuthReadSecretIdAccessorResult.class);
    }

    public Uni<Void> deleteSecretIdAccessor(VaultClient vaultClient, String token, String name, VaultAppRoleAuthReadSecretIdAccessorData body) {
        return vaultClient.post(this.opName("Delete secret ID accessor"), this.getAppRoleAuthMountPath() + "/role/" + name + "/secret-id-accessor/destroy", token, (Object)body, 204);
    }
}

