/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.MutinyVertxClientFactory;
import io.quarkus.vault.runtime.client.Private;
import io.quarkus.vault.runtime.client.Shared;
import io.quarkus.vault.runtime.client.VertxVaultClient;
import io.quarkus.vertx.runtime.VertxRecorder;
import io.vertx.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;

@Singleton
@Shared
public class SharedVertxVaultClient
extends VertxVaultClient {
    private final AtomicReference<WebClient> webClient = new AtomicReference();

    @Produces
    @Dependent
    public static VertxVaultClient createSharedVaultClient() {
        AnnotationLiteral clientType = VertxRecorder.getVertx() != null ? Shared.Literal.INSTANCE : Private.Literal.INSTANCE;
        return (VertxVaultClient)Arc.container().select(VertxVaultClient.class, new Annotation[]{clientType}).get();
    }

    public SharedVertxVaultClient(VaultConfigHolder vaultConfigHolder, TlsConfig tlsConfig) {
        super(vaultConfigHolder.getVaultBootstrapConfig().url.orElseThrow(() -> new VaultException("no vault url provided")), vaultConfigHolder.getVaultBootstrapConfig().enterprise.namespace, vaultConfigHolder.getVaultBootstrapConfig().readTimeout);
        io.vertx.mutiny.core.Vertx vertx = io.vertx.mutiny.core.Vertx.newInstance((Vertx)VertxRecorder.getVertx());
        this.webClient.set(MutinyVertxClientFactory.createHttpClient(vertx, vaultConfigHolder.getVaultBootstrapConfig(), tlsConfig));
    }

    @Override
    protected WebClient getWebClient() {
        return this.webClient.get();
    }

    @Override
    @PreDestroy
    public void close() {
        WebClient webClient = this.webClient.getAndSet(null);
        if (webClient != null) {
            webClient.close();
        }
    }
}

