/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.authmethod;

import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuth;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthBody;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthConfigData;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthConfigResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthListRolesResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthReadRoleResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthRoleData;
import io.smallrye.mutiny.Uni;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class VaultInternalKubernetesAuthMethod
extends VaultInternalBase {
    @Inject
    private VaultConfigHolder vaultConfigHolder;

    private String getKubernetesAuthMountPath() {
        return this.vaultConfigHolder.getVaultBootstrapConfig().authentication.kubernetes.authMountPath;
    }

    @Override
    protected String opNamePrefix() {
        return super.opNamePrefix() + " [AUTH (k8s)]";
    }

    public Uni<VaultKubernetesAuth> login(VaultClient vaultClient, String role, String jwt) {
        VaultKubernetesAuthBody body = new VaultKubernetesAuthBody(role, jwt);
        return vaultClient.post(this.opName("Login"), this.getKubernetesAuthMountPath() + "/login", null, (Object)body, VaultKubernetesAuth.class);
    }

    public Uni<Void> createAuthRole(VaultClient vaultClient, String token, String name, VaultKubernetesAuthRoleData body) {
        return vaultClient.post(this.opName("Create Role"), this.getKubernetesAuthMountPath() + "/role/" + name, token, (Object)body, 204);
    }

    public Uni<VaultKubernetesAuthReadRoleResult> getVaultAuthRole(VaultClient vaultClient, String token, String name) {
        return vaultClient.get(this.opName("Get Role"), this.getKubernetesAuthMountPath() + "/role/" + name, token, VaultKubernetesAuthReadRoleResult.class);
    }

    public Uni<VaultKubernetesAuthListRolesResult> listAuthRoles(VaultClient vaultClient, String token) {
        return vaultClient.list(this.opName("List Roles"), this.getKubernetesAuthMountPath() + "/role", token, VaultKubernetesAuthListRolesResult.class);
    }

    public Uni<Void> deleteAuthRoles(VaultClient vaultClient, String token, String name) {
        return vaultClient.delete(this.opName("Delete Role"), this.getKubernetesAuthMountPath() + "/role/" + name, token, 204);
    }

    public Uni<Void> configureAuth(VaultClient vaultClient, String token, VaultKubernetesAuthConfigData config) {
        return vaultClient.post(this.opName("Configure"), this.getKubernetesAuthMountPath() + "/config", token, (Object)config, 204);
    }

    public Uni<VaultKubernetesAuthConfigResult> readAuthConfig(VaultClient vaultClient, String token) {
        return vaultClient.get(this.opName("Read Configuration"), this.getKubernetesAuthMountPath() + "/config", token, VaultKubernetesAuthConfigResult.class);
    }
}

