/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.runtime.LeaseBase;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultDynamicCredentials;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.backend.VaultInternalSystemBackend;
import io.quarkus.vault.runtime.client.dto.dynamic.VaultDynamicCredentialsData;
import io.quarkus.vault.runtime.client.secretengine.VaultInternalDynamicCredentialsSecretEngine;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

@Singleton
public class VaultDynamicCredentialsManager {
    private static final Logger log = Logger.getLogger((String)VaultDynamicCredentialsManager.class.getName());
    private ConcurrentHashMap<String, VaultDynamicCredentials> credentialsCache = new ConcurrentHashMap();
    private VaultClient vaultClient;
    private VaultAuthManager vaultAuthManager;
    private VaultConfigHolder vaultConfigHolder;
    private VaultInternalSystemBackend vaultInternalSystemBackend;
    private VaultInternalDynamicCredentialsSecretEngine vaultInternalDynamicCredentialsSecretEngine;

    public VaultDynamicCredentialsManager(VaultClient vaultClient, VaultConfigHolder vaultConfigHolder, VaultAuthManager vaultAuthManager, VaultInternalSystemBackend vaultInternalSystemBackend, VaultInternalDynamicCredentialsSecretEngine vaultInternalDynamicCredentialsSecretEngine) {
        this.vaultClient = vaultClient;
        this.vaultConfigHolder = vaultConfigHolder;
        this.vaultAuthManager = vaultAuthManager;
        this.vaultInternalSystemBackend = vaultInternalSystemBackend;
        this.vaultInternalDynamicCredentialsSecretEngine = vaultInternalDynamicCredentialsSecretEngine;
    }

    private String getCredentialsPath(String mount, String requestPath) {
        return mount + "/" + requestPath;
    }

    private String getCredentialsCacheKey(String mount, String requestPath, String role) {
        return this.getCredentialsPath(mount, requestPath) + "@" + role;
    }

    VaultDynamicCredentials getCachedCredentials(String mount, String requestPath, String role) {
        return this.credentialsCache.get(this.getCredentialsCacheKey(mount, requestPath, role));
    }

    void putCachedCredentials(String mount, String requestPath, String role, VaultDynamicCredentials credentials) {
        this.credentialsCache.put(this.getCredentialsCacheKey(mount, requestPath, role), credentials);
    }

    private VaultBootstrapConfig getConfig() {
        return this.vaultConfigHolder.getVaultBootstrapConfig();
    }

    public Uni<Map<String, String>> getDynamicCredentials(String mount, String requestPath, String role) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            VaultDynamicCredentials currentCredentials = this.getCachedCredentials(mount, requestPath, role);
            return this.getCredentials(currentCredentials, (String)token, mount, requestPath, role).map(credentials -> {
                this.putCachedCredentials(mount, requestPath, role, (VaultDynamicCredentials)credentials);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("user", credentials.username);
                properties.put("password", credentials.password);
                properties.put("expires-at", credentials.getExpireInstant().toString());
                return properties;
            });
        });
    }

    public Uni<VaultDynamicCredentials> getCredentials(VaultDynamicCredentials currentCredentials, String clientToken, String mount, String requestPath, String role) {
        return Uni.createFrom().item(Optional.ofNullable(currentCredentials)).flatMap(credentials -> this.validate((Optional<VaultDynamicCredentials>)credentials, clientToken)).flatMap(credentials -> {
            if (credentials.isPresent() && ((VaultDynamicCredentials)credentials.get()).shouldExtend(this.getConfig().renewGracePeriod)) {
                return this.extend((VaultDynamicCredentials)credentials.get(), clientToken, mount, requestPath, role).map(Optional::of);
            }
            return Uni.createFrom().item(credentials);
        }).flatMap(credentials -> {
            if (credentials.isEmpty() || ((VaultDynamicCredentials)credentials.get()).isExpired() || ((VaultDynamicCredentials)credentials.get()).expiresSoon(this.getConfig().renewGracePeriod)) {
                return this.create(clientToken, mount, requestPath, role);
            }
            return Uni.createFrom().item((Object)((VaultDynamicCredentials)credentials.get()));
        });
    }

    private Uni<Optional<VaultDynamicCredentials>> validate(Optional<VaultDynamicCredentials> credentials, String clientToken) {
        if (credentials.isEmpty()) {
            return Uni.createFrom().item(Optional.empty());
        }
        return this.vaultInternalSystemBackend.lookupLease(this.vaultClient, clientToken, credentials.get().leaseId).map(ignored -> credentials).onFailure(VaultClientException.class).recoverWithUni(e -> {
            if (((VaultClientException)e).getStatus() == 400) {
                log.debug((Object)("lease " + ((VaultDynamicCredentials)credentials.get()).leaseId + " has become invalid"));
                return Uni.createFrom().item(Optional.empty());
            }
            return Uni.createFrom().failure(e);
        });
    }

    private Uni<VaultDynamicCredentials> extend(VaultDynamicCredentials currentCredentials, String clientToken, String mount, String requestPath, String role) {
        return this.vaultInternalSystemBackend.renewLease(this.vaultClient, clientToken, currentCredentials.leaseId).map(vaultRenewLease -> {
            LeaseBase lease = new LeaseBase(vaultRenewLease.leaseId, vaultRenewLease.renewable, vaultRenewLease.leaseDurationSecs);
            VaultDynamicCredentials credentials = new VaultDynamicCredentials(lease, currentCredentials.username, currentCredentials.password);
            this.sanityCheck(credentials, mount, requestPath, role);
            log.debug((Object)("extended " + role + "(" + this.getCredentialsPath(mount, requestPath) + ") credentials:" + credentials.getConfidentialInfo(this.getConfig().logConfidentialityLevel)));
            return credentials;
        });
    }

    private Uni<VaultDynamicCredentials> create(String clientToken, String mount, String requestPath, String role) {
        return this.vaultInternalDynamicCredentialsSecretEngine.generateCredentials(this.vaultClient, clientToken, mount, requestPath, role).map(vaultDynamicCredentials -> {
            LeaseBase lease = new LeaseBase(vaultDynamicCredentials.leaseId, vaultDynamicCredentials.renewable, vaultDynamicCredentials.leaseDurationSecs);
            VaultDynamicCredentials credentials = new VaultDynamicCredentials(lease, ((VaultDynamicCredentialsData)vaultDynamicCredentials.data).username, ((VaultDynamicCredentialsData)vaultDynamicCredentials.data).password);
            log.debug((Object)("generated " + role + "(" + this.getCredentialsPath(mount, requestPath) + ") credentials:" + credentials.getConfidentialInfo(this.getConfig().logConfidentialityLevel)));
            this.sanityCheck(credentials, mount, requestPath, role);
            return credentials;
        });
    }

    private void sanityCheck(VaultDynamicCredentials credentials, String mount, String requestPath, String role) {
        credentials.leaseDurationSanityCheck(role + " (" + this.getCredentialsPath(mount, requestPath) + ")", this.getConfig().renewGracePeriod);
    }
}

