/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultKubernetesAuthReactiveService;
import io.quarkus.vault.auth.VaultKubernetesAuthConfig;
import io.quarkus.vault.auth.VaultKubernetesAuthRole;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.authmethod.VaultInternalKubernetesAuthMethod;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthConfigData;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthListRolesData;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthRoleData;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;

@ApplicationScoped
public class VaultKubernetesAuthManager
implements VaultKubernetesAuthReactiveService {
    @Inject
    private VaultClient vaultClient;
    @Inject
    private VaultAuthManager vaultAuthManager;
    @Inject
    private VaultInternalKubernetesAuthMethod vaultInternalKubernetesAuthMethod;

    @Override
    public Uni<Void> configure(VaultKubernetesAuthConfig config) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalKubernetesAuthMethod.configureAuth(this.vaultClient, (String)token, new VaultKubernetesAuthConfigData().setIssuer(config.issuer).setKubernetesCaCert(config.kubernetesCaCert).setKubernetesHost(config.kubernetesHost).setPemKeys(config.pemKeys).setTokenReviewerJwt(config.tokenReviewerJwt)));
    }

    @Override
    public Uni<VaultKubernetesAuthConfig> getConfig() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalKubernetesAuthMethod.readAuthConfig(this.vaultClient, (String)token).map(result -> new VaultKubernetesAuthConfig().setKubernetesCaCert(((VaultKubernetesAuthConfigData)result.data).kubernetesCaCert).setKubernetesHost(((VaultKubernetesAuthConfigData)result.data).kubernetesHost).setIssuer(((VaultKubernetesAuthConfigData)result.data).issuer).setPemKeys(((VaultKubernetesAuthConfigData)result.data).pemKeys).setTokenReviewerJwt(((VaultKubernetesAuthConfigData)result.data).tokenReviewerJwt)));
    }

    @Override
    public Uni<VaultKubernetesAuthRole> getRole(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalKubernetesAuthMethod.getVaultAuthRole(this.vaultClient, (String)token, name).map(result -> {
            VaultKubernetesAuthRoleData role = (VaultKubernetesAuthRoleData)result.data;
            return new VaultKubernetesAuthRole().setBoundServiceAccountNames(role.boundServiceAccountNames).setBoundServiceAccountNamespaces(role.boundServiceAccountNamespaces).setAudience(role.audience).setTokenTtl(role.tokenTtl).setTokenMaxTtl(role.tokenMaxTtl).setTokenPolicies(role.tokenPolicies).setTokenBoundCidrs(role.tokenBoundCidrs).setTokenExplicitMaxTtl(role.tokenExplicitMaxTtl).setTokenNoDefaultPolicy(role.tokenNoDefaultPolicy).setTokenNumUses(role.tokenNumUses).setTokenPeriod(role.tokenPeriod).setTokenType(role.tokenType);
        }));
    }

    @Override
    public Uni<Void> createRole(String name, VaultKubernetesAuthRole role) {
        VaultKubernetesAuthRoleData body = new VaultKubernetesAuthRoleData().setBoundServiceAccountNames(role.boundServiceAccountNames).setBoundServiceAccountNamespaces(role.boundServiceAccountNamespaces).setAudience(role.audience).setTokenTtl(role.tokenTtl).setTokenMaxTtl(role.tokenMaxTtl).setTokenPolicies(role.tokenPolicies).setTokenBoundCidrs(role.tokenBoundCidrs).setTokenExplicitMaxTtl(role.tokenExplicitMaxTtl).setTokenNoDefaultPolicy(role.tokenNoDefaultPolicy).setTokenNumUses(role.tokenNumUses).setTokenPeriod(role.tokenPeriod).setTokenType(role.tokenType);
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalKubernetesAuthMethod.createAuthRole(this.vaultClient, (String)token, name, body));
    }

    @Override
    public Uni<List<String>> getRoles() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalKubernetesAuthMethod.listAuthRoles(this.vaultClient, (String)token).map(r -> ((VaultKubernetesAuthListRolesData)r.data).keys).onFailure(VaultClientException.class).recoverWithUni(e -> {
            if (((VaultClientException)e).getStatus() == 404) {
                return Uni.createFrom().item(Collections.emptyList());
            }
            return Uni.createFrom().failure(e);
        }));
    }

    @Override
    public Uni<Void> deleteRole(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalKubernetesAuthMethod.deleteAuthRoles(this.vaultClient, (String)token, name));
    }
}

