/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultSystemBackendReactiveEngine;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.backend.VaultInternalSystemBackend;
import io.quarkus.vault.runtime.client.dto.sys.VaultEnableEngineBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultListPolicyData;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyData;
import io.quarkus.vault.runtime.client.dto.sys.VaultSecretEngineInfoData;
import io.quarkus.vault.runtime.client.dto.sys.VaultTuneBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultTuneData;
import io.quarkus.vault.runtime.config.VaultBuildTimeConfig;
import io.quarkus.vault.sys.EnableEngineOptions;
import io.quarkus.vault.sys.VaultHealth;
import io.quarkus.vault.sys.VaultHealthStatus;
import io.quarkus.vault.sys.VaultInit;
import io.quarkus.vault.sys.VaultSealStatus;
import io.quarkus.vault.sys.VaultSecretEngine;
import io.quarkus.vault.sys.VaultSecretEngineInfo;
import io.quarkus.vault.sys.VaultTuneInfo;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;

@ApplicationScoped
public class VaultSystemBackendManager
implements VaultSystemBackendReactiveEngine {
    @Inject
    private VaultClient vaultClient;
    @Inject
    private VaultBuildTimeConfig buildTimeConfig;
    @Inject
    private VaultAuthManager vaultAuthManager;
    @Inject
    private VaultInternalSystemBackend vaultInternalSystemBackend;

    @Override
    public Uni<VaultInit> init(int secretShares, int secretThreshold) {
        return this.vaultInternalSystemBackend.init(this.vaultClient, secretShares, secretThreshold).map(init -> new VaultInit(init.keys, init.keysBase64, init.rootToken));
    }

    @Override
    public Uni<VaultHealth> health() {
        boolean isStandByOk = this.buildTimeConfig.health.standByOk;
        boolean isPerfStandByOk = this.buildTimeConfig.health.performanceStandByOk;
        return this.health(isStandByOk, isPerfStandByOk);
    }

    @Override
    public Uni<VaultHealthStatus> healthStatus() {
        boolean isStandByOk = this.buildTimeConfig.health.standByOk;
        boolean isPerfStandByOk = this.buildTimeConfig.health.performanceStandByOk;
        return this.healthStatus(isStandByOk, isPerfStandByOk);
    }

    @Override
    public Uni<VaultSealStatus> sealStatus() {
        return this.vaultInternalSystemBackend.systemSealStatus(this.vaultClient).map(vaultSealStatusResult -> {
            VaultSealStatus vaultSealStatus = new VaultSealStatus();
            vaultSealStatus.setClusterId(vaultSealStatusResult.clusterId);
            vaultSealStatus.setClusterName(vaultSealStatusResult.clusterName);
            vaultSealStatus.setInitialized(vaultSealStatusResult.initialized);
            vaultSealStatus.setMigration(vaultSealStatusResult.migration);
            vaultSealStatus.setN(vaultSealStatusResult.n);
            vaultSealStatus.setNonce(vaultSealStatusResult.nonce);
            vaultSealStatus.setProgress(vaultSealStatusResult.progress);
            vaultSealStatus.setRecoverySeal(vaultSealStatusResult.recoverySeal);
            vaultSealStatus.setSealed(vaultSealStatusResult.sealed);
            vaultSealStatus.setT(vaultSealStatusResult.t);
            vaultSealStatus.setType(vaultSealStatusResult.type);
            vaultSealStatus.setVersion(vaultSealStatusResult.version);
            return vaultSealStatus;
        });
    }

    private Uni<VaultHealthStatus> healthStatus(boolean isStandByOk, boolean isPerfStandByOk) {
        return this.vaultInternalSystemBackend.systemHealthStatus(this.vaultClient, isStandByOk, isPerfStandByOk).map(vaultHealthResult -> {
            VaultHealthStatus vaultHealthStatus = new VaultHealthStatus();
            vaultHealthStatus.setClusterId(vaultHealthResult.clusterId);
            vaultHealthStatus.setClusterName(vaultHealthResult.clusterName);
            vaultHealthStatus.setInitialized(vaultHealthResult.initialized);
            vaultHealthStatus.setPerformanceStandby(vaultHealthResult.performanceStandby);
            vaultHealthStatus.setReplicationDrMode(vaultHealthResult.replicationDrMode);
            vaultHealthStatus.setReplicationPerfMode(vaultHealthResult.replicationPerfMode);
            vaultHealthStatus.setSealed(vaultHealthResult.sealed);
            vaultHealthStatus.setServerTimeUtc(vaultHealthResult.serverTimeUtc);
            vaultHealthStatus.setStandby(vaultHealthResult.standby);
            vaultHealthStatus.setVersion(vaultHealthResult.version);
            return vaultHealthStatus;
        });
    }

    private Uni<VaultHealth> health(boolean isStandByOk, boolean isPerfStandByOk) {
        return this.vaultInternalSystemBackend.systemHealth(this.vaultClient, isStandByOk, isPerfStandByOk).map(VaultHealth::new);
    }

    @Override
    public Uni<String> getPolicyRules(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.getPolicy(this.vaultClient, (String)token, name).map(r -> ((VaultPolicyData)r.data).rules));
    }

    @Override
    public Uni<Void> createUpdatePolicy(String name, String policy) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.createUpdatePolicy(this.vaultClient, (String)token, name, new VaultPolicyBody(policy)));
    }

    @Override
    public Uni<Void> deletePolicy(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.deletePolicy(this.vaultClient, (String)token, name));
    }

    @Override
    public Uni<List<String>> getPolicies() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.listPolicies(this.vaultClient, (String)token).map(r -> ((VaultListPolicyData)r.data).policies));
    }

    @Override
    public Uni<VaultSecretEngineInfo> getSecretEngineInfo(String mount) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.getSecretEngineInfo(this.vaultClient, (String)token, mount).map(result -> {
            VaultSecretEngineInfo info = new VaultSecretEngineInfo();
            info.setDescription(((VaultSecretEngineInfoData)result.data).description);
            info.setType(((VaultSecretEngineInfoData)result.data).type);
            info.setLocal(((VaultSecretEngineInfoData)result.data).local);
            info.setExternalEntropyAccess(((VaultSecretEngineInfoData)result.data).externalEntropyAccess);
            info.setSealWrap(((VaultSecretEngineInfoData)result.data).sealWrap);
            info.setOptions(((VaultSecretEngineInfoData)result.data).options);
            return info;
        }));
    }

    @Override
    public Uni<VaultTuneInfo> getTuneInfo(String mount) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.getTuneInfo(this.vaultClient, (String)token, mount).map(vaultTuneResult -> {
            VaultTuneInfo tuneInfo = new VaultTuneInfo();
            tuneInfo.setDefaultLeaseTimeToLive(((VaultTuneData)vaultTuneResult.data).defaultLeaseTimeToLive);
            tuneInfo.setMaxLeaseTimeToLive(((VaultTuneData)vaultTuneResult.data).maxLeaseTimeToLive);
            tuneInfo.setDescription(((VaultTuneData)vaultTuneResult.data).description);
            tuneInfo.setForceNoCache(((VaultTuneData)vaultTuneResult.data).forceNoCache);
            return tuneInfo;
        }));
    }

    @Override
    public Uni<Void> updateTuneInfo(String mount, VaultTuneInfo tuneInfoUpdates) {
        VaultTuneBody body = new VaultTuneBody();
        body.description = tuneInfoUpdates.getDescription();
        body.defaultLeaseTimeToLive = tuneInfoUpdates.getDefaultLeaseTimeToLive();
        body.maxLeaseTimeToLive = tuneInfoUpdates.getMaxLeaseTimeToLive();
        body.forceNoCache = tuneInfoUpdates.getForceNoCache();
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.updateTuneInfo(this.vaultClient, (String)token, mount, body));
    }

    @Override
    public Uni<Boolean> isEngineMounted(String mount) {
        return this.getSecretEngineInfo(mount).map(i -> true).onFailure(VaultClientException.class).recoverWithUni(x -> {
            if (((VaultClientException)x).getStatus() == 405) {
                return this.getTuneInfo(mount).map(i -> true);
            }
            return Uni.createFrom().failure(x);
        }).onFailure(VaultClientException.class).recoverWithUni(x -> {
            if (((VaultClientException)x).getStatus() == 400) {
                return Uni.createFrom().item((Object)false);
            }
            return Uni.createFrom().failure(x);
        });
    }

    @Override
    public Uni<Void> enable(VaultSecretEngine engine, String mount, String description, EnableEngineOptions options) {
        return this.enable(engine.getType(), mount, description, options);
    }

    @Override
    public Uni<Void> enable(String engineType, String mount, String description, EnableEngineOptions options) {
        VaultEnableEngineBody body = new VaultEnableEngineBody();
        body.type = engineType;
        body.description = description;
        body.config = new VaultEnableEngineBody.Config();
        body.config.defaultLeaseTimeToLive = options.defaultLeaseTimeToLive;
        body.config.maxLeaseTimeToLive = options.maxLeaseTimeToLive;
        body.options = options.options;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.enableEngine(this.vaultClient, (String)token, mount, body));
    }

    @Override
    public Uni<Void> disable(String mount) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.disableEngine(this.vaultClient, (String)token, mount));
    }
}

