/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.vault.VaultAppRoleAuthReactiveService;
import io.quarkus.vault.auth.VaultAppRoleAuthRole;
import io.quarkus.vault.auth.VaultAppRoleSecretId;
import io.quarkus.vault.auth.VaultAppRoleSecretIdAccessor;
import io.quarkus.vault.auth.VaultAppRoleSecretIdRequest;
import io.quarkus.vault.runtime.client.VaultClientException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;

@ApplicationScoped
public class VaultAppRoleAuthService {
    private final VaultAppRoleAuthReactiveService service;

    @Inject
    public VaultAppRoleAuthService(VaultAppRoleAuthReactiveService service) {
        this.service = service;
    }

    public List<String> getAppRoles() {
        return (List)this.service.getAppRoles().await().indefinitely();
    }

    public void createOrUpdateAppRole(String name, VaultAppRoleAuthRole appRole) {
        this.service.createOrUpdateAppRole(name, appRole).await().indefinitely();
    }

    public void deleteAppRole(String name) {
        this.service.deleteAppRole(name).await().indefinitely();
    }

    public VaultAppRoleAuthRole getAppRole(String name) {
        return (VaultAppRoleAuthRole)this.service.getAppRole(name).await().indefinitely();
    }

    public String getAppRoleRoleId(String name) {
        return (String)this.service.getAppRoleRoleId(name).await().indefinitely();
    }

    public void setAppRoleRoleId(String name, String roleId) {
        this.service.setAppRoleRoleId(name, roleId).await().indefinitely();
    }

    public VaultAppRoleSecretId createNewSecretId(String name, VaultAppRoleSecretIdRequest newSecretIdRequest) {
        return (VaultAppRoleSecretId)this.service.createNewSecretId(name, newSecretIdRequest).await().indefinitely();
    }

    public VaultAppRoleSecretId createCustomSecretId(String name, VaultAppRoleSecretIdRequest newSecretIdRequest) {
        return (VaultAppRoleSecretId)this.service.createCustomSecretId(name, newSecretIdRequest).await().indefinitely();
    }

    public List<String> getSecretIdAccessors(String name) {
        return (List)this.service.getSecretIdAccessors(name).await().indefinitely();
    }

    public VaultAppRoleSecretIdAccessor getSecretIdAccessor(String name, String accessorId) {
        return (VaultAppRoleSecretIdAccessor)this.service.getSecretIdAccessor(name, accessorId).await().indefinitely();
    }

    public void deleteSecretIdAccessor(String name, String accessorId) {
        this.service.deleteSecretIdAccessor(name, accessorId).await().indefinitely();
    }

    public VaultAppRoleSecretIdAccessor getSecretId(String name, String secretId) {
        try {
            return (VaultAppRoleSecretIdAccessor)this.service.getSecretId(name, secretId).await().indefinitely();
        }
        catch (VaultClientException e) {
            if (e.getStatus() == 204) {
                return null;
            }
            throw e;
        }
    }

    public void deleteSecretId(String name, String secretId) {
        this.service.deleteSecretId(name, secretId).await().indefinitely();
    }
}

