/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import io.quarkus.runtime.TlsConfig;
import io.quarkus.vault.runtime.config.VaultAuthenticationType;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import org.jboss.logging.Logger;

public class MutinyVertxClientFactory {
    private static final Logger log = Logger.getLogger((String)MutinyVertxClientFactory.class.getName());

    public static WebClient createHttpClient(Vertx vertx, VaultRuntimeConfig vaultRuntimeConfig, TlsConfig tlsConfig) {
        boolean trustAll;
        WebClientOptions options = new WebClientOptions().setConnectTimeout((int)vaultRuntimeConfig.connectTimeout().toMillis()).setIdleTimeout((int)vaultRuntimeConfig.readTimeout().getSeconds() * 2);
        if (vaultRuntimeConfig.proxyHost().isPresent()) {
            options.setProxyOptions(new ProxyOptions().setHost(vaultRuntimeConfig.proxyHost().get()).setPort(vaultRuntimeConfig.proxyPort().intValue()));
        }
        if (vaultRuntimeConfig.nonProxyHosts().isPresent()) {
            options.setNonProxyHosts(vaultRuntimeConfig.nonProxyHosts().get());
        }
        if (trustAll = vaultRuntimeConfig.tls().skipVerify().orElseGet(() -> tlsConfig.trustAll).booleanValue()) {
            MutinyVertxClientFactory.skipVerify(options);
        } else if (vaultRuntimeConfig.tls().caCert().isPresent()) {
            MutinyVertxClientFactory.cacert(options, vaultRuntimeConfig.tls().caCert().get());
        } else if (vaultRuntimeConfig.getAuthenticationType() == VaultAuthenticationType.KUBERNETES && vaultRuntimeConfig.tls().useKubernetesCaCert()) {
            MutinyVertxClientFactory.cacert(options, "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
        }
        return WebClient.create((Vertx)vertx, (WebClientOptions)options);
    }

    private static void cacert(WebClientOptions options, String cacert) {
        log.debug((Object)("configure tls with " + cacert));
        options.setTrustOptions((TrustOptions)new PemTrustOptions().addCertPath(cacert));
    }

    private static void skipVerify(WebClientOptions options) {
        log.debug((Object)"configure tls with skip-verify");
        options.setTrustAll(true);
        options.setVerifyHost(false);
    }
}

