/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.config;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.jboss.logging.Logger;

public class VaultCacheEntry<V> {
    private static final Logger log = Logger.getLogger((String)VaultCacheEntry.class.getName());
    private V value;
    private volatile Instant created = Instant.now();

    public static <V> V tryReturnLastKnownValue(RuntimeException e, VaultCacheEntry<V> cacheEntry) {
        if (e.getCause() instanceof IOException && cacheEntry != null) {
            log.debug((Object)"unable to fetch secrets from vault; returning last known value", (Throwable)e);
            cacheEntry.reset();
            return cacheEntry.getValue();
        }
        throw e;
    }

    public VaultCacheEntry(V value) {
        this.value = value;
    }

    public boolean youngerThan(Duration duration) {
        return this.created.plus(duration).isAfter(Instant.now());
    }

    public V getValue() {
        return this.value;
    }

    public void reset() {
        this.created = Instant.now();
    }
}

