/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.config;

import io.quarkus.arc.Arc;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.VaultKVSecretReactiveEngine;
import io.quarkus.vault.runtime.VaultIOException;
import io.quarkus.vault.runtime.client.Private;
import io.quarkus.vault.runtime.config.VaultCacheEntry;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class VaultConfigSource
implements ConfigSource {
    private static final Logger log = Logger.getLogger(VaultConfigSource.class);
    private AtomicReference<VaultCacheEntry<Map<String, String>>> cache = new AtomicReference<Object>(null);
    private VaultRuntimeConfig vaultRuntimeConfig;
    private volatile boolean firstTime = true;

    public VaultConfigSource(VaultRuntimeConfig vaultRuntimeConfig) {
        this.vaultRuntimeConfig = vaultRuntimeConfig;
    }

    public String getName() {
        return "vault";
    }

    public int getOrdinal() {
        return this.vaultRuntimeConfig.configOrdinal();
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public Set<String> getPropertyNames() {
        return Collections.emptySet();
    }

    public String getValue(String propertyName) {
        return this.vaultRuntimeConfig.url().isPresent() ? this.getSecretConfig().get(propertyName) : null;
    }

    private Map<String, String> getSecretConfig() {
        VaultCacheEntry<Map<String, String>> cacheEntry = this.cache.get();
        if (cacheEntry != null && cacheEntry.youngerThan(this.vaultRuntimeConfig.secretConfigCachePeriod())) {
            return cacheEntry.getValue();
        }
        if (!Infrastructure.canCallerThreadBeBlocked()) {
            return cacheEntry != null ? cacheEntry.getValue() : Collections.emptyMap();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.firstTime) {
            log.debug((Object)("fetch secrets first time with attempts = " + this.vaultRuntimeConfig.mpConfigInitialAttempts()));
            this.fetchSecretsFirstTime(properties);
            this.firstTime = false;
        } else {
            try {
                this.fetchSecrets(properties);
                log.debug((Object)("refreshed " + properties.size() + " properties from vault"));
            }
            catch (RuntimeException e) {
                return VaultCacheEntry.tryReturnLastKnownValue(e, cacheEntry);
            }
        }
        this.cache.set(new VaultCacheEntry<HashMap<String, String>>(properties));
        return properties;
    }

    private void fetchSecretsFirstTime(Map<String, String> properties) {
        VaultIOException last = null;
        for (int i = 0; i < this.vaultRuntimeConfig.mpConfigInitialAttempts(); ++i) {
            try {
                if (i > 0) {
                    log.debug((Object)"retrying to fetch secrets");
                }
                this.fetchSecrets(properties);
                log.debug((Object)("loaded " + properties.size() + " properties from vault"));
                return;
            }
            catch (VaultIOException e) {
                log.debug((Object)("attempt " + (i + 1) + " to fetch secrets from vault failed with: " + e));
                last = e;
                continue;
            }
        }
        if (last == null) {
            throw new VaultException("unexpected");
        }
        throw last;
    }

    private void fetchSecrets(Map<String, String> properties) {
        this.vaultRuntimeConfig.secretConfigKvPath().ifPresent(strings -> this.fetchSecrets((List<String>)strings, null, properties));
        this.vaultRuntimeConfig.secretConfigKvPathPrefix().forEach((key, value) -> this.fetchSecrets(value.paths(), (String)key, properties));
    }

    private void fetchSecrets(List<String> paths, String prefix, Map<String, String> properties) {
        paths.forEach(path -> properties.putAll(this.fetchSecrets((String)path, prefix)));
    }

    private Map<String, String> fetchSecrets(String path, String prefix) {
        Map secrets = (Map)this.getVaultKVSecretEngine().readSecret(path).await().indefinitely();
        return this.prefixMap(secrets, prefix);
    }

    private VaultKVSecretReactiveEngine getVaultKVSecretEngine() {
        return (VaultKVSecretReactiveEngine)Arc.container().instance(VaultKVSecretReactiveEngine.class, new Annotation[]{Private.Literal.INSTANCE}).get();
    }

    private Map<String, String> prefixMap(Map<String, String> map, String prefix) {
        return prefix == null ? map : map.entrySet().stream().collect(Collectors.toMap(entry -> prefix + "." + (String)entry.getKey(), Map.Entry::getValue));
    }
}

