/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.LogConfidentialityLevel;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultToken;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.authmethod.VaultInternalAppRoleAuthMethod;
import io.quarkus.vault.runtime.client.authmethod.VaultInternalKubernetesAuthMethod;
import io.quarkus.vault.runtime.client.authmethod.VaultInternalTokenAuthMethod;
import io.quarkus.vault.runtime.client.authmethod.VaultInternalUserpassAuthMethod;
import io.quarkus.vault.runtime.client.backend.VaultInternalSystemBackend;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleAuthAuth;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleGenerateNewSecretID;
import io.quarkus.vault.runtime.client.dto.auth.VaultAppRoleGenerateNewSecretIDData;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthAuth;
import io.quarkus.vault.runtime.client.dto.auth.VaultRenewSelfAuth;
import io.quarkus.vault.runtime.client.dto.auth.VaultTokenCreate;
import io.quarkus.vault.runtime.client.dto.auth.VaultTokenCreateAuth;
import io.quarkus.vault.runtime.client.dto.auth.VaultUserPassAuthAuth;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretJsonV1;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretJsonV2;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretJsonV2Data;
import io.quarkus.vault.runtime.config.VaultAuthenticationType;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jboss.logging.Logger;

@Singleton
public class VaultAuthManager {
    private static final Logger log = Logger.getLogger((String)VaultAuthManager.class.getName());
    public static final String USERPASS_WRAPPING_TOKEN_PASSWORD_KEY = "password";
    private AtomicReference<VaultToken> loginCache = new AtomicReference<Object>(null);
    private Cache<String, Uni<String>> unwrappingCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build();
    private VaultConfigHolder vaultConfigHolder;
    private VaultInternalSystemBackend vaultInternalSystemBackend;
    private VaultInternalAppRoleAuthMethod vaultInternalAppRoleAuthMethod;
    private VaultInternalKubernetesAuthMethod vaultInternalKubernetesAuthMethod;
    private VaultInternalUserpassAuthMethod vaultInternalUserpassAuthMethod;
    private VaultInternalTokenAuthMethod vaultInternalTokenAuthMethod;

    VaultAuthManager(VaultConfigHolder vaultConfigHolder, VaultInternalSystemBackend vaultInternalSystemBackend, VaultInternalAppRoleAuthMethod vaultInternalAppRoleAuthMethod, VaultInternalKubernetesAuthMethod vaultInternalKubernetesAuthMethod, VaultInternalUserpassAuthMethod vaultInternalUserpassAuthMethod, VaultInternalTokenAuthMethod vaultInternalTokenAuthMethod) {
        this.vaultConfigHolder = vaultConfigHolder;
        this.vaultInternalSystemBackend = vaultInternalSystemBackend;
        this.vaultInternalAppRoleAuthMethod = vaultInternalAppRoleAuthMethod;
        this.vaultInternalKubernetesAuthMethod = vaultInternalKubernetesAuthMethod;
        this.vaultInternalUserpassAuthMethod = vaultInternalUserpassAuthMethod;
        this.vaultInternalTokenAuthMethod = vaultInternalTokenAuthMethod;
    }

    private VaultRuntimeConfig getConfig() {
        return this.vaultConfigHolder.getVaultRuntimeConfig();
    }

    public Uni<String> getClientToken(VaultClient vaultClient) {
        return this.getConfig().authentication().isDirectClientToken() ? this.getDirectClientToken(vaultClient) : this.login(vaultClient).map(vaultToken -> vaultToken.clientToken);
    }

    private Uni<String> getDirectClientToken(VaultClient vaultClient) {
        Optional<String> clientTokenOption = this.getConfig().authentication().clientToken();
        if (clientTokenOption.isPresent()) {
            return Uni.createFrom().item((Object)clientTokenOption.get());
        }
        return this.unwrapWrappingTokenOnce(vaultClient, "client token", this.getConfig().authentication().clientTokenWrappingToken().get(), unwrap -> ((VaultTokenCreateAuth)unwrap.auth).clientToken, VaultTokenCreate.class);
    }

    private Uni<VaultToken> login(VaultClient vaultClient) {
        return this.login(vaultClient, this.loginCache.get()).map(vaultToken -> {
            this.loginCache.set((VaultToken)vaultToken);
            return vaultToken;
        });
    }

    public Uni<VaultToken> login(VaultClient vaultClient, VaultToken currentVaultToken) {
        return Uni.createFrom().item(Optional.ofNullable(currentVaultToken)).flatMap(vaultToken -> this.validate(vaultClient, (Optional<VaultToken>)vaultToken)).flatMap(vaultToken -> {
            if (vaultToken.isPresent() && ((VaultToken)vaultToken.get()).shouldExtend(this.getConfig().renewGracePeriod())) {
                return this.extend(vaultClient, ((VaultToken)vaultToken.get()).clientToken).map(Optional::of);
            }
            return Uni.createFrom().item(vaultToken);
        }).flatMap(vaultToken -> {
            if (vaultToken.isEmpty() || ((VaultToken)vaultToken.get()).isExpired() || ((VaultToken)vaultToken.get()).expiresSoon(this.getConfig().renewGracePeriod())) {
                return this.vaultLogin(vaultClient);
            }
            return Uni.createFrom().item((Object)((VaultToken)vaultToken.get()));
        });
    }

    private Uni<Optional<VaultToken>> validate(VaultClient vaultClient, Optional<VaultToken> vaultToken) {
        if (vaultToken.isEmpty()) {
            return Uni.createFrom().item(Optional.empty());
        }
        return this.vaultInternalTokenAuthMethod.lookupSelf(vaultClient, vaultToken.get().clientToken).map(i -> vaultToken).onFailure(VaultClientException.class).recoverWithUni(e -> {
            if (((VaultClientException)e).getStatus() == 403) {
                log.debug((Object)("login token " + ((VaultToken)vaultToken.get()).clientToken + " has become invalid"));
                return Uni.createFrom().item(Optional.empty());
            }
            return Uni.createFrom().failure(e);
        });
    }

    private Uni<VaultToken> extend(VaultClient vaultClient, String clientToken) {
        return this.vaultInternalTokenAuthMethod.renewSelf(vaultClient, clientToken, null).map(renew -> {
            VaultToken vaultToken = new VaultToken(((VaultRenewSelfAuth)renew.auth).clientToken, ((VaultRenewSelfAuth)renew.auth).renewable, ((VaultRenewSelfAuth)renew.auth).leaseDurationSecs);
            this.sanityCheck(vaultToken);
            log.debug((Object)("extended login token: " + vaultToken.getConfidentialInfo(this.getConfig().logConfidentialityLevel())));
            return vaultToken;
        });
    }

    private Uni<VaultToken> vaultLogin(VaultClient vaultClient) {
        return this.login(vaultClient, this.getConfig().getAuthenticationType()).map(vaultToken -> {
            this.sanityCheck((VaultToken)vaultToken);
            log.debug((Object)("created new login token: " + vaultToken.getConfidentialInfo(this.getConfig().logConfidentialityLevel())));
            return vaultToken;
        });
    }

    private Uni<VaultToken> login(VaultClient vaultClient, VaultAuthenticationType type) {
        Uni authRequest;
        if (type == VaultAuthenticationType.KUBERNETES) {
            authRequest = this.loginKubernetes(vaultClient);
        } else if (type == VaultAuthenticationType.USERPASS) {
            String username = this.getConfig().authentication().userpass().username().get();
            authRequest = this.getPassword(vaultClient).flatMap(password -> this.vaultInternalUserpassAuthMethod.login(vaultClient, username, (String)password).map(r -> (VaultUserPassAuthAuth)r.auth));
        } else if (type == VaultAuthenticationType.APPROLE) {
            String roleId = this.getConfig().authentication().appRole().roleId().get();
            authRequest = this.getSecretId(vaultClient).flatMap(secretId -> this.vaultInternalAppRoleAuthMethod.login(vaultClient, roleId, (String)secretId)).map(r -> (VaultAppRoleAuthAuth)r.auth);
        } else {
            throw new UnsupportedOperationException("unknown authType " + this.getConfig().getAuthenticationType());
        }
        return authRequest.map(auth -> new VaultToken(auth.clientToken, auth.renewable, auth.leaseDurationSecs));
    }

    private Uni<String> getSecretId(VaultClient vaultClient) {
        Optional<String> secretIdOption = this.getConfig().authentication().appRole().secretId();
        if (secretIdOption.isPresent()) {
            return Uni.createFrom().item((Object)secretIdOption.get());
        }
        return this.unwrapWrappingTokenOnce(vaultClient, "secret id", this.getConfig().authentication().appRole().secretIdWrappingToken().get(), unwrap -> ((VaultAppRoleGenerateNewSecretIDData)unwrap.data).secretId, VaultAppRoleGenerateNewSecretID.class);
    }

    private Uni<String> getPassword(VaultClient vaultClient) {
        Optional<String> passwordOption = this.getConfig().authentication().userpass().password();
        if (passwordOption.isPresent()) {
            return Uni.createFrom().item((Object)passwordOption.get());
        }
        String wrappingToken = this.getConfig().authentication().userpass().passwordWrappingToken().get();
        if (this.getConfig().kvSecretEngineVersion() == 1) {
            Function<VaultKvSecretJsonV1, String> f = unwrap -> (String)((Map)unwrap.data).get(USERPASS_WRAPPING_TOKEN_PASSWORD_KEY);
            return this.unwrapWrappingTokenOnce(vaultClient, USERPASS_WRAPPING_TOKEN_PASSWORD_KEY, wrappingToken, f, VaultKvSecretJsonV1.class);
        }
        Function<VaultKvSecretJsonV2, String> f = unwrap -> (String)((VaultKvSecretJsonV2Data)unwrap.data).data.get(USERPASS_WRAPPING_TOKEN_PASSWORD_KEY);
        return this.unwrapWrappingTokenOnce(vaultClient, USERPASS_WRAPPING_TOKEN_PASSWORD_KEY, wrappingToken, f, VaultKvSecretJsonV2.class);
    }

    private <T> Uni<String> unwrapWrappingTokenOnce(VaultClient vaultClient, String type, String wrappingToken, Function<T, String> f, Class<T> clazz) {
        return (Uni)this.unwrappingCache.get((Object)wrappingToken, token -> this.vaultInternalSystemBackend.unwrap(vaultClient, (String)token, clazz).map(unwrap -> {
            String wrappedValue = (String)f.apply(unwrap);
            String displayValue = this.getConfig().logConfidentialityLevel().maskWithTolerance(wrappedValue, LogConfidentialityLevel.LOW);
            log.debug((Object)("unwrapped " + type + ": " + displayValue));
            return wrappedValue;
        }).onFailure(VaultClientException.class).transform(e -> {
            if (((VaultClientException)e).getStatus() == 400) {
                String message = "wrapping token is not valid or does not exist; this means that the token has already expired (if so you can increase the ttl on the wrapping token) or has been consumed by somebody else (potentially indicating that the wrapping token has been stolen)";
                return new VaultException(message, (Throwable)e);
            }
            return e;
        }).memoize().indefinitely());
    }

    private Uni<VaultKubernetesAuthAuth> loginKubernetes(VaultClient vaultClient) {
        String jwt = new String(this.read(this.getConfig().authentication().kubernetes().jwtTokenPath()), StandardCharsets.UTF_8);
        log.debug((Object)("authenticate with jwt at: " + this.getConfig().authentication().kubernetes().jwtTokenPath() + " => " + this.getConfig().logConfidentialityLevel().maskWithTolerance(jwt, LogConfidentialityLevel.LOW)));
        String role = this.getConfig().authentication().kubernetes().role().get();
        return this.vaultInternalKubernetesAuthMethod.login(vaultClient, role, jwt).map(r -> (VaultKubernetesAuthAuth)r.auth);
    }

    private byte[] read(String path) {
        try {
            return Files.readAllBytes(Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void sanityCheck(VaultToken vaultToken) {
        vaultToken.leaseDurationSanityCheck("auth", this.getConfig().renewGracePeriod());
    }
}

