/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.VaultKVSecretEngine;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultDynamicCredentialsManager;
import io.quarkus.vault.runtime.config.CredentialsProviderConfig;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.Map;

@ApplicationScoped
@Named(value="vault-credentials-provider")
public class VaultCredentialsProvider
implements CredentialsProvider {
    @Inject
    VaultKVSecretEngine vaultKVSecretEngine;
    @Inject
    VaultDynamicCredentialsManager vaultDynamicCredentialsManager;
    @Inject
    VaultConfigHolder vaultConfigHolder;

    public Map<String, String> getCredentials(String credentialsProviderName) {
        VaultRuntimeConfig vaultConfig = this.getConfig();
        if (vaultConfig == null) {
            throw new VaultException("missing Vault configuration required for credentials providers with name " + credentialsProviderName);
        }
        CredentialsProviderConfig config = vaultConfig.credentialsProvider().get(credentialsProviderName);
        if (config == null) {
            throw new VaultException("unknown credentials provider with name " + credentialsProviderName);
        }
        if (config.databaseCredentialsRole().isPresent()) {
            return (Map)this.vaultDynamicCredentialsManager.getDynamicCredentials("database", "creds", config.databaseCredentialsRole().get()).await().indefinitely();
        }
        if (config.credentialsRole().isPresent()) {
            return (Map)this.vaultDynamicCredentialsManager.getDynamicCredentials(config.credentialsMount(), config.credentialsRequestPath(), config.credentialsRole().get()).await().indefinitely();
        }
        if (config.kvPath().isPresent()) {
            String password = this.vaultKVSecretEngine.readSecret(config.kvPath().get()).get(config.kvKey());
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("password", password);
            return result;
        }
        throw new VaultException("one of database-credentials-role or kv-path is required on credentials provider " + credentialsProviderName);
    }

    private VaultRuntimeConfig getConfig() {
        return this.vaultConfigHolder.getVaultRuntimeConfig();
    }
}

